/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.send;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseURL;
import adams.core.net.rabbitmq.send.AbstractConverter;
import adams.core.net.rabbitmq.send.BinaryConverter;
import adams.core.net.rabbitmq.send.StringConverter;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.rest.dex.DataExchangeHelper;
import adams.flow.rest.dex.clientauthentication.AbstractClientAuthentication;
import adams.flow.rest.dex.clientauthentication.NoAuthentication;
import adams.flow.standalone.DataExchangeServerConnection;
import com.fasterxml.jackson.databind.ObjectMapper;

public class DataExchangeServerBasedConverter
extends AbstractConverter {
    private static final long serialVersionUID = -736244897402323379L;
    protected AbstractConverter m_Converter;
    protected boolean m_UseFlowContextConnection;
    protected transient DataExchangeServerConnection m_Connection;
    protected BaseURL m_Server;
    protected AbstractClientAuthentication m_Authentication;
    protected transient ObjectMapper m_Mapper;
    protected transient BaseURL m_ActualURL;
    protected AbstractClientAuthentication m_ActualAuthentication;

    public String globalInfo() {
        return "Instead of sending potentially large payloads via a RabbitMQ, this meta-converter uploads the payload to the specified data exchange server and only sends the token for obtaining the data again via RabbitMQ.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("converter", "converter", (Object)new BinaryConverter());
        this.m_OptionManager.add("use-flow-context-connection", "useFlowContextConnection", (Object)false);
        this.m_OptionManager.add("server", "server", (Object)new BaseURL("http://localhost:8080/upload"));
        this.m_OptionManager.add("authentication", "authentication", (Object)new NoAuthentication());
    }

    protected void reset() {
        super.reset();
        this.m_Mapper = null;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)((Object)this.m_Converter), (String)"converter: ");
        if (this.m_UseFlowContextConnection) {
            result = result + ", connection from flow context";
        } else {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"server", (Object)this.m_Server, (String)", server: ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"authentication", (Object)((Object)this.m_Authentication), (String)", auth: ");
        }
        return result;
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The base converter for performing the actual conversion.";
    }

    public void setUseFlowContextConnection(boolean value) {
        this.m_UseFlowContextConnection = value;
        this.reset();
    }

    public boolean getUseFlowContextConnection() {
        return this.m_UseFlowContextConnection;
    }

    public String useFlowContextConnectionTipText() {
        return "If enabled, the data exchange server connection available through the flow context is used rather than the server/authentication defined here.";
    }

    public void setServer(BaseURL value) {
        this.m_Server = value;
        this.reset();
    }

    public BaseURL getServer() {
        return this.m_Server;
    }

    public String serverTipText() {
        return "The data exchange server to use.";
    }

    public void setAuthentication(AbstractClientAuthentication value) {
        this.m_Authentication = value;
        this.reset();
    }

    public AbstractClientAuthentication getAuthentication() {
        return this.m_Authentication;
    }

    public String authenticationTipText() {
        return "The authentication to use for accessing the server.";
    }

    @Override
    public Class[] accepts() {
        return this.m_Converter.accepts();
    }

    @Override
    public String check(Object payload) {
        String result = super.check(payload);
        if (result == null && this.m_UseFlowContextConnection && this.m_Connection == null) {
            this.m_Connection = (DataExchangeServerConnection)ActorUtils.findClosestType((Actor)this.getFlowContext(), DataExchangeServerConnection.class);
            if (this.m_Connection == null) {
                result = "No " + DataExchangeServerConnection.class.getName() + " actor found!";
            }
        }
        if (result == null && this.m_ActualURL == null) {
            if (this.m_Connection != null) {
                this.m_ActualURL = this.m_Connection.buildURL("upload");
                this.m_ActualAuthentication = this.m_Connection.getAuthentication();
            } else {
                this.m_ActualURL = DataExchangeHelper.buildURL(this.m_Server, "upload");
                this.m_ActualAuthentication = this.m_Authentication;
                this.m_ActualAuthentication.setFlowContext(this.getFlowContext());
            }
        }
        return result;
    }

    @Override
    protected byte[] doConvert(Object payload, MessageCollection errors) {
        byte[] data = this.m_Converter.convert(payload, errors);
        if (!errors.isEmpty()) {
            return null;
        }
        this.m_Authentication.setFlowContext(this.getFlowContext());
        String token = DataExchangeHelper.upload(data, this.m_ActualURL, this.m_ActualAuthentication, errors);
        byte[] result = errors.isEmpty() && token != null ? new StringConverter().convert(token, errors) : null;
        return result;
    }
}

