/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.send;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.TempUtils;
import adams.core.net.rabbitmq.send.AbstractConverter;
import adams.core.net.rabbitmq.send.BinaryConverter;
import adams.core.net.rabbitmq.send.StringConverter;
import adams.core.option.OptionHandler;
import java.io.File;

public class FileBasedConverter
extends AbstractConverter {
    private static final long serialVersionUID = -736244897402323379L;
    protected AbstractConverter m_Converter;
    protected PlaceholderDirectory m_PayloadDir;

    public String globalInfo() {
        return "Instead of sending potentially large payloads via a RabbitMQ, this meta-converter stores the actual payload in the specified directory and only sends the file name (without path) via RabbitMQ.\nOf course, requires sending and receiving ends to have access to the same directory.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("converter", "converter", (Object)new BinaryConverter());
        this.m_OptionManager.add("payload-dir", "payloadDir", (Object)new PlaceholderDirectory());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)((Object)this.m_Converter), (String)"converter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"payloadDir", (Object)this.m_PayloadDir, (String)", dir: ");
        return result;
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The base converter for performing the actual conversion.";
    }

    public void setPayloadDir(PlaceholderDirectory value) {
        this.m_PayloadDir = value;
        this.reset();
    }

    public PlaceholderDirectory getPayloadDir() {
        return this.m_PayloadDir;
    }

    public String payloadDirTipText() {
        return "The directory for saving the actual payload to.";
    }

    @Override
    public Class[] accepts() {
        return this.m_Converter.accepts();
    }

    @Override
    protected byte[] doConvert(Object payload, MessageCollection errors) {
        byte[] result;
        byte[] data = this.m_Converter.convert(payload, errors);
        if (!errors.isEmpty()) {
            return null;
        }
        File file = TempUtils.createTempFile((PlaceholderDirectory)this.m_PayloadDir, (String)"rabbitmq-", (String)".ser");
        try {
            SerializationHelper.write((String)file.getAbsolutePath(), (Object)data);
            result = new StringConverter().convert(file.getName(), errors);
        }
        catch (Exception e) {
            errors.add("Failed to serialize payload to: " + file, (Throwable)e);
            result = null;
        }
        return result;
    }
}

