/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import com.rabbitmq.client.Envelope;
import java.util.HashMap;
import java.util.Map;

public class RabbitMQEnvelopeToMap
extends AbstractConversion {
    private static final long serialVersionUID = 6432647148987897719L;
    public static final String KEY_DELIVERY_TAG = "DeliveryTag";
    public static final String KEY_EXCHANGE = "Exchange";
    public static final String KEY_ROUTING_KEY = "RoutingKey";
    public static final String KEY_IS_REDELIVER = "IsRedeliver";
    public static final String[] KEYS = new String[]{"DeliveryTag", "Exchange", "RoutingKey", "IsRedeliver"};

    public String globalInfo() {
        return "Converts RabbitMQ envelope into a Java Map.\nCan be used to obtain the delivery tag of a message to acknowledge successful consumption.\nAvailable keys:\n" + Utils.commentOut((String)Utils.flatten((Object[])KEYS, (String)"\n"), (String)"- ");
    }

    public Class accepts() {
        return Envelope.class;
    }

    public Class generates() {
        return Map.class;
    }

    protected Object doConvert() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Envelope env = (Envelope)this.m_Input;
        result.put(KEY_DELIVERY_TAG, env.getDeliveryTag());
        result.put(KEY_EXCHANGE, env.getExchange());
        result.put(KEY_ROUTING_KEY, env.getRoutingKey());
        result.put(KEY_IS_REDELIVER, env.isRedeliver());
        return result;
    }
}

