/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import com.rabbitmq.client.AMQP;
import java.util.HashMap;
import java.util.Map;

public class RabbitMQPropertiesToMap
extends AbstractConversion {
    private static final long serialVersionUID = 6432647148987897719L;
    public static final String KEY_APP_ID = "AppId";
    public static final String KEY_CLASS_ID = "ClassId";
    public static final String KEY_CLASS_NAME = "ClassName";
    public static final String KEY_CLUSTER_ID = "ClusterId";
    public static final String KEY_CONTENT_ENCODING = "ContentEncoding";
    public static final String KEY_CONTENT_TYPE = "ContentType";
    public static final String KEY_CORRELATION_ID = "CorrelationId";
    public static final String KEY_DELIVERY_MODE = "DeliveryMode";
    public static final String KEY_EXPIRATION = "Expiration";
    public static final String KEY_HEADERS = "Headers";
    public static final String KEY_MESSAGE_ID = "MessageId";
    public static final String KEY_PRIORITY = "Priority";
    public static final String KEY_REPLY_TO = "ReplyTo";
    public static final String KEY_TIMESTAMP = "Timestamp";
    public static final String KEY_TYPE = "Type";
    public static final String KEY_USER_ID = "UserId";
    public static final String KEY_BODY_SIZE = "BodySize";
    public static final String[] KEYS = new String[]{"AppId", "ClassId", "ClassName", "ClusterId", "ContentEncoding", "ContentType", "CorrelationId", "DeliveryMode", "Expiration", "Headers", "MessageId", "Priority", "ReplyTo", "Timestamp", "Type", "UserId", "BodySize"};

    public String globalInfo() {
        return "Converts RabbitMQ properties into a Java Map.\nCan be used to obtain the replyto queue name for sending back results.\nAvailable keys:\n" + Utils.commentOut((String)Utils.flatten((Object[])KEYS, (String)"\n"), (String)"- ");
    }

    public Class accepts() {
        return AMQP.BasicProperties.class;
    }

    public Class generates() {
        return Map.class;
    }

    protected Object doConvert() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AMQP.BasicProperties props = (AMQP.BasicProperties)this.m_Input;
        result.put(KEY_APP_ID, props.getAppId());
        result.put(KEY_CLASS_ID, props.getClassId());
        result.put(KEY_CLASS_NAME, props.getClassName());
        result.put(KEY_CLUSTER_ID, props.getClusterId());
        result.put(KEY_CONTENT_ENCODING, props.getContentEncoding());
        result.put(KEY_CONTENT_TYPE, props.getContentType());
        result.put(KEY_CORRELATION_ID, props.getCorrelationId());
        result.put(KEY_DELIVERY_MODE, props.getDeliveryMode());
        result.put(KEY_EXPIRATION, props.getExpiration());
        result.put(KEY_HEADERS, props.getHeaders());
        result.put(KEY_MESSAGE_ID, props.getMessageId());
        result.put(KEY_PRIORITY, props.getPriority());
        result.put(KEY_REPLY_TO, props.getReplyTo());
        result.put(KEY_TIMESTAMP, props.getTimestamp());
        result.put(KEY_TYPE, props.getType());
        result.put(KEY_USER_ID, props.getUserId());
        result.put(KEY_BODY_SIZE, props.getBodySize());
        return result;
    }
}

