/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import java.util.ArrayList;
import java.util.Iterator;

public class RabbitMQConsumptionContainer
extends AbstractContainer {
    private static final long serialVersionUID = 6669185450978836875L;
    public static final String VALUE_DATA = "Data";
    public static final String VALUE_PROPERTIES = "Properties";
    public static final String VALUE_ENVELOPE = "Envelope";
    public static final String VALUE_CHANNEL = "Channel";

    public RabbitMQConsumptionContainer() {
        this(null, null);
    }

    public RabbitMQConsumptionContainer(Object data) {
        this(data, null);
    }

    public RabbitMQConsumptionContainer(Object data, AMQP.BasicProperties properties) {
        this(data, properties, null);
    }

    public RabbitMQConsumptionContainer(Object data, AMQP.BasicProperties properties, Envelope envelope) {
        this(data, properties, envelope, null);
    }

    public RabbitMQConsumptionContainer(Object data, AMQP.BasicProperties properties, Envelope envelope, Channel channel) {
        this.store(VALUE_DATA, data);
        this.store(VALUE_PROPERTIES, properties);
        this.store(VALUE_ENVELOPE, envelope);
        this.store(VALUE_CHANNEL, channel);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_DATA, "the payload data", Object.class);
        this.addHelp(VALUE_PROPERTIES, "optional properties that were received", AMQP.BasicProperties.class);
        this.addHelp(VALUE_ENVELOPE, "optional delivery envelope", Envelope.class);
        this.addHelp(VALUE_CHANNEL, "optional channel object (eg for sending back ack's)", Channel.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_DATA);
        result.add(VALUE_PROPERTIES);
        result.add(VALUE_ENVELOPE);
        result.add(VALUE_CHANNEL);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_DATA);
    }
}

