/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.UniqueIDs;
import adams.core.Utils;
import adams.core.VariableName;
import adams.core.Variables;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.send.AbstractConverter;
import adams.core.net.rabbitmq.send.BinaryConverter;
import adams.core.option.OptionHandler;
import adams.flow.container.EncapsulatedActorsContainer;
import adams.flow.control.AbstractControlActor;
import adams.flow.control.Sequence;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.standalone.RabbitMQConnection;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DeliverCallback;
import java.util.Hashtable;

public abstract class AbstractRabbitMQControlActor
extends AbstractControlActor
implements MutableActorHandler {
    private static final long serialVersionUID = 5816569944356142679L;
    public static final String BACKUP_INPUT = "input";
    public static final String BACKUP_OUTPUT = "output";
    protected transient Token m_InputToken;
    protected transient Token m_OutputToken;
    protected Sequence m_Actors;
    protected StorageName[] m_StorageNames;
    protected VariableName[] m_VariableNames;
    protected String m_Queue;
    protected AbstractConverter m_SendConverter;
    protected transient RabbitMQConnection m_Connection;
    protected transient Channel m_Channel;
    protected transient Long m_Processing;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", (Object)new Actor[0]);
        this.m_OptionManager.add("storage-name", "storageNames", (Object)new StorageName[0]);
        this.m_OptionManager.add("variable-name", "variableNames", (Object)new VariableName[0]);
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("send-converter", "sendConverter", (Object)new BinaryConverter());
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setActors(new Actor[]{new Null()});
    }

    public void setActors(Actor[] value) {
        String msg = this.checkSubActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public Actor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to execute remotely.";
    }

    public void setStorageNames(StorageName[] value) {
        this.m_StorageNames = value;
        this.reset();
    }

    public StorageName[] getStorageNames() {
        return this.m_StorageNames;
    }

    public String storageNamesTipText() {
        return "The (optional) storage items to transfer.";
    }

    public void setVariableNames(VariableName[] value) {
        this.m_VariableNames = value;
        this.reset();
    }

    public VariableName[] getVariableNames() {
        return this.m_VariableNames;
    }

    public String variableNamesTipText() {
        return "The (optional) variables to transfer.";
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setSendConverter(AbstractConverter value) {
        this.m_SendConverter = value;
        this.reset();
    }

    public AbstractConverter getSendConverter() {
        return this.m_SendConverter;
    }

    public String sendConverterTipText() {
        return "The converter to use for sending.";
    }

    public String getQuickInfo() {
        String value = super.getQuickInfo();
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)"queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sendConverter", (Object)((Object)this.m_SendConverter), (String)", send: ");
        if (value != null) {
            result = result + ", " + value;
        }
        return result;
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        if (this.m_OutputToken != null) {
            result.put(BACKUP_OUTPUT, this.m_OutputToken);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        if (state.containsKey(BACKUP_OUTPUT)) {
            this.m_OutputToken = (Token)state.get(BACKUP_OUTPUT);
            state.remove(BACKUP_OUTPUT);
        }
        super.restoreState(state);
    }

    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        this.m_Actors.forceVariables(value);
    }

    public int size() {
        return this.m_Actors.size();
    }

    public Actor get(int index) {
        return this.m_Actors.get(index);
    }

    public String set(int index, Actor actor) {
        String result = this.checkSubActor(index, actor);
        if (result == null) {
            this.m_Actors.set(index, actor);
            this.reset();
            this.updateParent();
        }
        return result;
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public String add(Actor actor) {
        return this.add(this.size(), actor);
    }

    public String add(int index, Actor actor) {
        if (actor == this) {
            throw new IllegalArgumentException("Cannot add itself!");
        }
        String result = this.checkSubActor(index, actor);
        if (result == null) {
            this.m_Actors.add(index, actor);
            this.reset();
            this.updateParent();
        }
        return result;
    }

    protected abstract String checkSubActor(int var1, Actor var2);

    protected abstract String checkSubActors(Actor[] var1);

    public Actor remove(int index) {
        Actor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    public abstract ActorHandlerInfo getActorHandlerInfo();

    public void input(Token token) {
        this.m_InputToken = token;
        this.m_OutputToken = null;
    }

    public boolean hasInput() {
        return this.m_InputToken != null;
    }

    public Token currentInput() {
        return this.m_InputToken;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (RabbitMQConnection)ActorUtils.findClosestType((Actor)this, RabbitMQConnection.class);
            if (this.m_Connection == null) {
                result = "No " + RabbitMQConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected abstract EncapsulatedActorsContainer encapsulate();

    protected abstract DeliverCallback generateDeliverCallback();

    protected String doExecute() {
        String result = null;
        this.m_SendConverter.setFlowContext((Actor)this);
        if (this.m_Channel == null) {
            this.m_Channel = this.m_Connection.createChannel();
            if (this.m_Channel == null) {
                result = "Failed to create a channel!";
            }
        }
        if (result == null) {
            EncapsulatedActorsContainer cont = this.encapsulate();
            MessageCollection errorsSnd = new MessageCollection();
            byte[] dataSnd = this.m_SendConverter.convert(cont, errorsSnd);
            if (!errorsSnd.isEmpty()) {
                result = errorsSnd.toString();
            }
            String callbackQueue = null;
            if (result == null) {
                try {
                    callbackQueue = this.m_Channel.queueDeclare().getQueue();
                    this.m_Connection.addAutoCreatedQueue(callbackQueue);
                    AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().replyTo(callbackQueue).build();
                    this.m_Channel.basicPublish("", this.m_Queue, props, dataSnd);
                }
                catch (Exception e) {
                    result = this.handleException("Failed to send flow container!", e);
                }
            }
            if (result == null) {
                try {
                    DeliverCallback deliverCallback = this.generateDeliverCallback();
                    this.m_Processing = UniqueIDs.nextLong();
                    this.m_Channel.basicConsume(callbackQueue, true, deliverCallback, consumerTag -> {});
                    while (this.m_Processing != null) {
                        Utils.wait((LoggingSupporter)this, (int)1000, (int)50);
                    }
                }
                catch (Exception e) {
                    result = this.handleException("Failed to receive flow container!", e);
                }
            }
        }
        return result;
    }

    protected String postExecute() {
        String result = super.postExecute();
        if (this.isStopped()) {
            this.m_OutputToken = null;
        }
        return result;
    }

    public String execute() {
        String result = super.execute();
        if (this.m_Skip) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        this.m_InputToken = null;
        return result;
    }

    public void wrapUp() {
        this.m_InputToken = null;
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

