/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex;

import adams.flow.rest.AbstractRESTPlugin;
import adams.flow.rest.dex.authentication.AbstractAuthentication;
import adams.flow.rest.dex.authentication.NoAuthenticationRequired;
import adams.flow.rest.dex.backend.AbstractBackend;
import adams.flow.rest.dex.backend.InMemory;
import com.fasterxml.jackson.databind.ObjectMapper;
import gnu.trove.list.array.TByteArrayList;
import java.io.InputStream;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;

public class DataExchange
extends AbstractRESTPlugin {
    private static final long serialVersionUID = -5218893638471880150L;
    public static final String PARAMKEY_NAME = "name";
    public static final String PARAMKEY_PAYLOAD = "payload";
    public static final String PARAMVALUE_TOKEN = "token";
    protected AbstractAuthentication m_Authentication;
    protected AbstractBackend m_Backend;
    protected transient ObjectMapper m_Mapper;

    public String globalInfo() {
        return "Allows clients to upload/download data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("authentication", "authentication", (Object)new NoAuthenticationRequired());
        this.m_OptionManager.add("backend", "backend", (Object)new InMemory());
    }

    protected void reset() {
        super.reset();
        this.m_Mapper = null;
    }

    public void setAuthentication(AbstractAuthentication value) {
        this.m_Authentication = value;
        this.reset();
    }

    public AbstractAuthentication getAuthentication() {
        return this.m_Authentication;
    }

    public String authenticationTipText() {
        return "The scheme to use for authenticating clients.";
    }

    public void setBackend(AbstractBackend value) {
        this.m_Backend = value;
        this.reset();
    }

    public AbstractBackend getBackend() {
        return this.m_Backend;
    }

    public String backendTipText() {
        return "The scheme to use for managing the uploaded data.";
    }

    protected Response handleError(String msg) {
        this.getLogger().severe(msg);
        return Response.status((int)500, (String)msg).build();
    }

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response upload(MultipartBody body) {
        String json;
        HashMap<String, String> parameters = new HashMap<String, String>();
        TByteArrayList payload = new TByteArrayList();
        for (Attachment att : body.getAllAttachments()) {
            String name = att.getContentDisposition().getParameter(PARAMKEY_NAME);
            if (name == null) continue;
            if (name.equals(PARAMKEY_PAYLOAD)) {
                try {
                    int data;
                    InputStream is = att.getDataHandler().getInputStream();
                    while ((data = is.read()) != -1) {
                        payload.add((byte)data);
                    }
                    continue;
                }
                catch (Exception e) {
                    payload = null;
                    continue;
                }
            }
            parameters.put(name, ((String)att.getObject(String.class)).trim());
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Parameters: " + parameters);
        }
        if (!(this.m_Authentication instanceof NoAuthenticationRequired)) {
            String msg = this.m_Authentication.authenticate(parameters);
            if (msg != null) {
                return this.handleError(msg);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Authentication successful!");
            }
        }
        if (payload == null) {
            return this.handleError("No payload provided!");
        }
        this.m_Backend.initBackend();
        String token = this.m_Backend.add(payload.toArray());
        if (token == null) {
            return this.handleError("Failed to add payload!");
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data stored under: " + token);
        }
        if (this.m_Mapper == null) {
            this.m_Mapper = new ObjectMapper();
        }
        try {
            json = this.m_Mapper.writeValueAsString((Object)new TokenMessage(token));
        }
        catch (Exception e) {
            return this.handleError("Failed to generate response with token!");
        }
        return Response.ok((Object)json, (String)"application/json").build();
    }

    @POST
    @Path(value="/download")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/octet-stream"})
    public Response download(MultipartBody body) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String token = null;
        for (Attachment att : body.getAllAttachments()) {
            String name = att.getContentDisposition().getParameter(PARAMKEY_NAME);
            if (name == null) continue;
            if (name.equals(PARAMVALUE_TOKEN)) {
                token = ((String)att.getObject(String.class)).trim();
                continue;
            }
            parameters.put(name, ((String)att.getObject(String.class)).trim());
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Parameters: " + parameters);
        }
        if (!(this.m_Authentication instanceof NoAuthenticationRequired)) {
            String msg = this.m_Authentication.authenticate(parameters);
            if (msg != null) {
                return this.handleError(msg);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Authentication successful!");
            }
        }
        if (token == null) {
            return this.handleError("No token provided!");
        }
        this.m_Backend.purge();
        byte[] data = this.m_Backend.get(token);
        if (data == null) {
            return this.handleError("No data for token available: " + token);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data retrieved for: " + token);
        }
        return Response.ok((Object)data, (String)"application/octet-stream").build();
    }

    @POST
    @Path(value="/remove")
    @Consumes(value={"multipart/form-data"})
    public Response remove(MultipartBody body) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String token = null;
        for (Attachment att : body.getAllAttachments()) {
            String name = att.getContentDisposition().getParameter(PARAMKEY_NAME);
            if (name == null) continue;
            if (name.equals(PARAMVALUE_TOKEN)) {
                token = ((String)att.getObject(String.class)).trim();
                continue;
            }
            parameters.put(name, ((String)att.getObject(String.class)).trim());
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Parameters: " + parameters);
        }
        if (!(this.m_Authentication instanceof NoAuthenticationRequired)) {
            String msg = this.m_Authentication.authenticate(parameters);
            if (msg != null) {
                return this.handleError(msg);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Authentication successful!");
            }
        }
        if (token == null) {
            return this.handleError("No token provided!");
        }
        this.m_Backend.purge();
        this.m_Backend.remove(token);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data removed for: " + token);
        }
        return Response.ok().build();
    }

    public static class TokenMessage {
        protected String m_Token;

        public TokenMessage() {
            this(null);
        }

        public TokenMessage(String token) {
            this.setToken(token);
        }

        public void setToken(String value) {
            this.m_Token = value;
        }

        public String getToken() {
            return this.m_Token;
        }
    }
}

