/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex.backend;

import adams.core.MessageCollection;
import adams.core.UniqueIDs;
import adams.core.io.MessageDigestType;
import adams.core.option.AbstractOptionHandler;

public abstract class AbstractBackend
extends AbstractOptionHandler {
    private static final long serialVersionUID = 3157981057620546957L;
    protected int m_TimeToLive;
    protected boolean m_SequentialTokens;
    protected boolean m_Initialized;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("time-to-live", "timeToLive", (Object)3600, (Number)1, null);
        this.m_OptionManager.add("sequential-tokens", "sequentialTokens", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    public void setTimeToLive(int value) {
        this.m_TimeToLive = value;
        this.reset();
    }

    public int getTimeToLive() {
        return this.m_TimeToLive;
    }

    public String timeToLiveTipText() {
        return "The time to live (in seconds) for the data items before they expire.";
    }

    public void setSequentialTokens(boolean value) {
        this.m_SequentialTokens = value;
        this.reset();
    }

    public boolean getSequentialTokens() {
        return this.m_SequentialTokens;
    }

    public String sequentialTokensTipText() {
        return "If enabled, sequential tokens are generated (for testing only).";
    }

    protected String nextToken() {
        MessageCollection errors = new MessageCollection();
        long id = UniqueIDs.nextLong();
        if (!this.m_SequentialTokens) {
            id += System.currentTimeMillis();
        }
        return MessageDigestType.SHA256.digest((Object)Long.toHexString(id), errors);
    }

    protected abstract String doInitBackend();

    public String initBackend() {
        String result;
        if (this.m_Initialized) {
            return null;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Initializing backend...");
        }
        if ((result = this.doInitBackend()) == null) {
            this.purge();
        }
        return result;
    }

    protected abstract void doClear();

    public void clear() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Clearing");
        }
        this.doClear();
    }

    protected abstract void doPurge();

    public void purge() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Purge");
        }
        this.doPurge();
    }

    protected abstract boolean hasItem(String var1);

    public boolean has(String token) {
        return this.hasItem(token);
    }

    protected abstract byte[] getItem(String var1);

    public byte[] get(String token) {
        return this.getItem(token);
    }

    protected abstract String addItem(byte[] var1);

    public String add(byte[] data) {
        return this.addItem(data);
    }

    protected abstract boolean removeItem(String var1);

    public boolean remove(String token) {
        return this.removeItem(token);
    }
}

