/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex.backend;

import adams.core.Utils;
import adams.flow.rest.dex.backend.AbstractBackend;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class InMemory
extends AbstractBackend {
    private static final long serialVersionUID = 918572755476028354L;
    protected Map<String, DataContainer> m_Storage;

    public String globalInfo() {
        return "Simply stores the uploaded data in memory, with no persistence.";
    }

    @Override
    protected String doInitBackend() {
        this.m_Storage = new HashMap<String, DataContainer>();
        return null;
    }

    @Override
    protected void doClear() {
        this.m_Storage.clear();
    }

    @Override
    protected void doPurge() {
        if (this.m_Storage.size() == 0) {
            return;
        }
        ArrayList<String> expired = new ArrayList<String>();
        for (String key : this.m_Storage.keySet()) {
            if (!this.m_Storage.get(key).hasExpired()) continue;
            expired.add(key);
        }
        if (expired.size() > 0) {
            for (String key : expired) {
                this.m_Storage.remove(key);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Purged: " + Utils.flatten(expired, (String)", "));
            }
        }
    }

    @Override
    protected boolean hasItem(String token) {
        return this.m_Storage.containsKey(token);
    }

    @Override
    protected byte[] getItem(String token) {
        DataContainer cont = this.m_Storage.get(token);
        if (cont != null) {
            return cont.getData();
        }
        return null;
    }

    @Override
    protected String addItem(byte[] data) {
        String result = this.nextToken();
        DataContainer cont = new DataContainer(data, new Date(System.currentTimeMillis() + (long)(this.m_TimeToLive * 1000)));
        this.m_Storage.put(result, cont);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data added: token=" + result + ", expiry=" + cont.getExpiry());
        }
        return result;
    }

    @Override
    protected boolean removeItem(String token) {
        DataContainer removed = this.m_Storage.remove(token);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data removed: " + token);
        }
        return removed != null;
    }

    public static class DataContainer
    implements Serializable {
        private static final long serialVersionUID = 1379234889822596730L;
        protected byte[] m_Data;
        protected Date m_Expiry;

        public DataContainer(byte[] data, Date expiry) {
            this.m_Data = data;
            this.m_Expiry = expiry;
        }

        public byte[] getData() {
            return this.m_Data;
        }

        public Date getExpiry() {
            return this.m_Expiry;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() >= this.m_Expiry.getTime();
        }
    }
}

