/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex.clientauthentication;

import adams.core.ClassCrossReference;
import adams.core.MessageCollection;
import adams.core.PasswordPrompter;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BasePassword;
import adams.flow.control.Flow;
import adams.flow.rest.dex.clientauthentication.AbstractClientAuthentication;
import adams.gui.dialog.PasswordDialog;
import java.awt.Dialog;
import java.awt.Window;

public class BasicAuthentication
extends AbstractClientAuthentication
implements ClassCrossReference,
PasswordPrompter {
    private static final long serialVersionUID = -8658731460295213717L;
    protected String m_User;
    protected BasePassword m_Password;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;

    public String globalInfo() {
        return "Generates simple user/password authentication.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("user", "user", (Object)"");
        this.m_OptionManager.add("password", "password", (Object)new BasePassword());
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_ActualPassword = null;
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The name of the user to connect as.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password for the user.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{adams.flow.rest.dex.authentication.BasicAuthentication.class};
    }

    @Override
    protected boolean requiresFlowContext() {
        return this.m_PromptForPassword;
    }

    protected boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog(null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getFlowContext().getParentComponent());
        ((Flow)this.getFlowContext().getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getFlowContext().getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    @Override
    protected BaseKeyValuePair[] doGenerate(MessageCollection errors) {
        if (this.m_ActualPassword == null) {
            if (this.m_PromptForPassword) {
                if (!this.doInteract()) {
                    errors.add("User canceled password dialog!");
                    return null;
                }
            } else {
                this.m_ActualPassword = this.m_Password;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("user/password: " + this.m_User + "/" + this.m_ActualPassword);
            }
        }
        return new BaseKeyValuePair[]{new BaseKeyValuePair("user", this.m_User), new BaseKeyValuePair("password", this.m_ActualPassword.getValue())};
    }
}

