/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.net.rabbitmq.deliveryaction.AbstractDeliveryAction;
import adams.core.net.rabbitmq.deliveryaction.NoAction;
import adams.core.option.OptionHandler;
import adams.data.conversion.RabbitMQEnvelopeToMap;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.sink.AbstractSink;
import com.rabbitmq.client.Channel;

public class RabbitMQMessageDeliveryAction
extends AbstractSink
implements ClassCrossReference,
StorageUser {
    private static final long serialVersionUID = -7073183797972945731L;
    protected StorageName m_StorageName;
    protected AbstractDeliveryAction m_Action;

    public String globalInfo() {
        return "Executes the specified message delivery action using the incoming delivery tag.\nThe specified storage item represents the channel used by the action.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{RabbitMQEnvelopeToMap.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("action", "action", (Object)new NoAction());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"channel: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"action", (Object)((Object)this.m_Action), (String)", action: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored channel to retrieve.";
    }

    public void setAction(AbstractDeliveryAction value) {
        this.m_Action = value;
        this.reset();
    }

    public AbstractDeliveryAction getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The message delivery action to execute.";
    }

    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    public Class[] accepts() {
        return new Class[]{Long.class};
    }

    protected String doExecute() {
        String result = null;
        Channel channel = null;
        if (this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            channel = (Channel)this.getStorageHandler().getStorage().get(this.m_StorageName);
        } else {
            result = "Failed to retrieve channel: '" + this.m_StorageName.getValue() + "'";
        }
        if (result == null) {
            Long tag = (Long)this.m_InputToken.getPayload(Long.class);
            this.m_Action.performAction(channel, tag);
        }
        return result;
    }
}

