/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.connection.AbstractConnectionFactory;
import adams.core.net.rabbitmq.connection.GuestConnectionFactory;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.ArrayList;
import java.util.List;

public class RabbitMQConnection
extends AbstractStandalone {
    private static final long serialVersionUID = -1726172998200420556L;
    protected AbstractConnectionFactory m_ConnectionFactory;
    protected int m_PrefetchCount;
    protected transient Connection m_Connection;
    protected List<String> m_AutoCreatedQueues;

    public String globalInfo() {
        return "Defines a connection to a RabbitMQ broker.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-factory", "connectionFactory", (Object)new GuestConnectionFactory());
        this.m_OptionManager.add("prefetch-count", "prefetchCount", (Object)1, (Number)0, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_AutoCreatedQueues = new ArrayList<String>();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"connectionFactory", (Object)((Object)this.m_ConnectionFactory));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"prefetchCount", (Object)(this.m_PrefetchCount == 0 ? "unlimited" : "" + this.m_PrefetchCount), (String)", prefetch: ");
        return result;
    }

    public void setConnectionFactory(AbstractConnectionFactory value) {
        this.m_ConnectionFactory = value;
        this.reset();
    }

    public AbstractConnectionFactory getConnectionFactory() {
        return this.m_ConnectionFactory;
    }

    public String connectionFactoryTipText() {
        return "The connection factory to use.";
    }

    public void setPrefetchCount(int value) {
        this.m_PrefetchCount = value;
        this.reset();
    }

    public int getPrefetchCount() {
        return this.m_PrefetchCount;
    }

    public String prefetchCountTipText() {
        return "The number of un-acked jobs a client can pull off a queue; 0 = unlimited, 1 = fair.";
    }

    protected String doExecute() {
        String result = null;
        MessageCollection errors = new MessageCollection();
        Connection conn = this.retrieveConnection(errors);
        if (conn == null || !conn.isOpen()) {
            result = !errors.isEmpty() ? errors.toString() : "Failed to connect to broker (" + (Object)((Object)this.m_ConnectionFactory) + ")!";
        }
        return result;
    }

    protected Connection retrieveConnection(MessageCollection errors) {
        if (errors == null) {
            errors = new MessageCollection();
        }
        ConnectionFactory factory = this.m_ConnectionFactory.generate(errors);
        if (!errors.isEmpty()) {
            return null;
        }
        try {
            return factory.newConnection();
        }
        catch (Exception e) {
            errors.add("Failed to connect to broker (" + (Object)((Object)this.m_ConnectionFactory) + ")!", (Throwable)e);
            this.handleException("Failed to connect to broker (" + (Object)((Object)this.m_ConnectionFactory) + ")!", e);
            return null;
        }
    }

    public Connection getConnection() {
        if (this.m_Connection == null) {
            this.m_Connection = this.retrieveConnection(null);
        }
        return this.m_Connection;
    }

    public Channel createChannel() {
        return RabbitMQHelper.createChannel((LoggingSupporter)this, this.getConnection(), this.m_PrefetchCount);
    }

    public void addAutoCreatedQueue(String queue) {
        this.m_AutoCreatedQueues.add(queue);
    }

    public void wrapUp() {
        RabbitMQHelper.closeQuietly(this.m_Connection, this.m_AutoCreatedQueues);
        this.m_Connection = null;
        super.wrapUp();
    }
}

