/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseURL;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.DataExchangeServerConnection;
import adams.flow.transformer.AbstractTransformer;
import com.fasterxml.jackson.databind.ObjectMapper;

public abstract class AbstractDataExchangeServerTransformer
extends AbstractTransformer {
    private static final long serialVersionUID = -2903084298983787897L;
    protected transient DataExchangeServerConnection m_Connection;
    protected transient ObjectMapper m_Mapper;
    protected transient BaseURL m_ActualURL;

    protected void reset() {
        super.reset();
        this.m_Mapper = null;
        this.m_ActualURL = null;
    }

    protected ObjectMapper getMapper() {
        if (this.m_Mapper == null) {
            this.m_Mapper = new ObjectMapper();
        }
        return this.m_Mapper;
    }

    protected abstract String getPath();

    protected BaseURL getActualUrl() {
        if (this.m_ActualURL == null) {
            this.m_ActualURL = this.m_Connection.buildURL(this.getPath());
        }
        return this.m_ActualURL;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (DataExchangeServerConnection)ActorUtils.findClosestType((Actor)this, DataExchangeServerConnection.class);
            if (this.m_Connection == null) {
                result = "No " + DataExchangeServerConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }
}

