/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.UniqueIDs;
import adams.core.Utils;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.receive.StringConverter;
import adams.core.net.rabbitmq.send.AbstractConverter;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.RabbitMQConnection;
import adams.flow.transformer.AbstractTransformer;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DeliverCallback;
import java.util.ArrayList;
import java.util.List;

public class RabbitMQRemoteProcedureCall
extends AbstractTransformer {
    private static final long serialVersionUID = 194761311376840744L;
    protected String m_Queue;
    protected AbstractConverter m_SendConverter;
    protected adams.core.net.rabbitmq.receive.AbstractConverter m_ReceiveConverter;
    protected transient RabbitMQConnection m_Connection;
    protected transient Channel m_Channel;
    protected List<Object> m_Data;
    protected transient Long m_Processing;

    public String globalInfo() {
        return "Performs a remote procedure call via a RabbitMQ broker.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("send-converter", "sendConverter", (Object)new adams.core.net.rabbitmq.send.StringConverter());
        this.m_OptionManager.add("receive-converter", "receiveConverter", (Object)new StringConverter());
    }

    protected void initialize() {
        super.initialize();
        this.m_Data = new ArrayList<Object>();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)"queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sendConverter", (Object)((Object)this.m_SendConverter), (String)", send: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"receiveConverter", (Object)((Object)this.m_ReceiveConverter), (String)", receive: ");
        return result;
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setSendConverter(AbstractConverter value) {
        this.m_SendConverter = value;
        this.reset();
    }

    public AbstractConverter getSendConverter() {
        return this.m_SendConverter;
    }

    public String sendConverterTipText() {
        return "The converter to use for sending.";
    }

    public void setReceiveConverter(adams.core.net.rabbitmq.receive.AbstractConverter value) {
        this.m_ReceiveConverter = value;
        this.reset();
    }

    public adams.core.net.rabbitmq.receive.AbstractConverter getReceiveConverter() {
        return this.m_ReceiveConverter;
    }

    public String receiveConverterTipText() {
        return "The converter to use for receiving data.";
    }

    public Class[] accepts() {
        return this.m_SendConverter.accepts();
    }

    public Class[] generates() {
        return new Class[]{this.m_ReceiveConverter.generates()};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (RabbitMQConnection)ActorUtils.findClosestType((Actor)this, RabbitMQConnection.class);
            if (this.m_Connection == null) {
                result = "No " + RabbitMQConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        this.m_Data.clear();
        this.m_SendConverter.setFlowContext((Actor)this);
        this.m_ReceiveConverter.setFlowContext((Actor)this);
        if (this.m_Channel == null) {
            this.m_Channel = this.m_Connection.createChannel();
            if (this.m_Channel == null) {
                result = "Failed to create a channel!";
            }
        }
        byte[] dataSnd = null;
        if (result == null) {
            MessageCollection errorsSnd = new MessageCollection();
            dataSnd = this.m_SendConverter.convert(this.m_InputToken.getPayload(), errorsSnd);
            if (!errorsSnd.isEmpty()) {
                result = errorsSnd.toString();
            }
        }
        String callbackQueue = null;
        if (result == null) {
            try {
                callbackQueue = this.m_Channel.queueDeclare().getQueue();
                this.m_Connection.addAutoCreatedQueue(callbackQueue);
                AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().replyTo(callbackQueue).build();
                this.m_Channel.basicPublish("", this.m_Queue, props, dataSnd);
            }
            catch (Exception e) {
                result = this.handleException("Failed to send data!", e);
            }
        }
        if (result == null) {
            try {
                DeliverCallback deliverCallback = (consumerTag, delivery) -> {
                    try {
                        byte[] dataRec = delivery.getBody();
                        MessageCollection errorsRec = new MessageCollection();
                        Object output = this.m_ReceiveConverter.convert(dataRec, errorsRec);
                        if (output != null) {
                            this.m_Data.add(output);
                        }
                    }
                    catch (Exception e) {
                        this.handleException("Failed to process received data!", e);
                    }
                    finally {
                        this.m_Processing = null;
                    }
                };
                this.m_Processing = UniqueIDs.nextLong();
                this.m_Channel.basicConsume(callbackQueue, true, deliverCallback, consumerTag -> {});
                while (this.m_Processing != null) {
                    Utils.wait((LoggingSupporter)this, (int)1000, (int)50);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to receive data!", e);
            }
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Data.size() > 0;
    }

    public Token output() {
        Token result = this.m_Data.size() > 0 ? new Token(this.m_Data.remove(0)) : null;
        return result;
    }

    public void stopExecution() {
        if (this.m_Processing != null) {
            this.m_Processing = null;
        }
        super.stopExecution();
    }

    public void wrapUp() {
        RabbitMQHelper.closeQuietly(this.m_Channel);
        this.m_Channel = null;
        super.wrapUp();
    }
}

