/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.connection;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.connection.AbstractConnectionFactory;
import adams.core.net.rabbitmq.connection.GuestConnectionFactory;
import adams.core.net.rabbitmq.send.AbstractConverter;
import adams.core.net.rabbitmq.send.StringConverter;
import adams.core.option.OptionHandler;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.connection.AbstractConnection;
import adams.scripting.processor.RemoteCommandProcessor;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;

public class RabbitMQConnection
extends AbstractConnection {
    private static final long serialVersionUID = 7719866884762680511L;
    protected AbstractConnectionFactory m_ConnectionFactory;
    protected int m_PrefetchCount;
    protected String m_Exchange;
    protected String m_Queue;
    protected AbstractConverter m_SendConverter;
    protected transient Connection m_Connection;
    protected transient Channel m_Channel;

    public String globalInfo() {
        return "Uses a RabbitMQ queue to send commands.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-factory", "connectionFactory", (Object)new GuestConnectionFactory());
        this.m_OptionManager.add("prefetch-count", "prefetchCount", (Object)1, (Number)0, null);
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("send-converter", "sendConverter", (Object)new StringConverter());
    }

    public void setConnectionFactory(AbstractConnectionFactory value) {
        this.m_ConnectionFactory = value;
        this.reset();
    }

    public AbstractConnectionFactory getConnectionFactory() {
        return this.m_ConnectionFactory;
    }

    public String connectionFactoryTipText() {
        return "The connection factory to use.";
    }

    public void setPrefetchCount(int value) {
        this.m_PrefetchCount = value;
        this.reset();
    }

    public int getPrefetchCount() {
        return this.m_PrefetchCount;
    }

    public String prefetchCountTipText() {
        return "The number of un-acked jobs a client can pull off a queue; 0 = unlimited, 1 = fair.";
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setSendConverter(AbstractConverter value) {
        this.m_SendConverter = value;
        this.reset();
    }

    public AbstractConverter getSendConverter() {
        return this.m_SendConverter;
    }

    public String sendConverterTipText() {
        return "The converter to use for sending.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"connectionFactory", (Object)((Object)this.m_ConnectionFactory), (String)"connection: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"prefetchCount", (Object)(this.m_PrefetchCount == 0 ? "unlimited" : "" + this.m_PrefetchCount), (String)", prefetch: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"exchange", (Object)(this.m_Exchange.isEmpty() ? "-empty-" : this.m_Exchange), (String)", exchange: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)", queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sendConverter", (Object)((Object)this.m_SendConverter), (String)", send: ");
        return result;
    }

    protected String connect() {
        String result = null;
        MessageCollection errors = new MessageCollection();
        ConnectionFactory factory = this.m_ConnectionFactory.generate(errors);
        if (!errors.isEmpty()) {
            return null;
        }
        try {
            this.m_Connection = factory.newConnection();
            if (this.m_Connection == null) {
                result = "Failed to connect to broker (" + (Object)((Object)this.m_ConnectionFactory) + ")!";
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to connect to broker (" + (Object)((Object)this.m_ConnectionFactory) + ")!"), (Throwable)e);
        }
        if (result == null) {
            try {
                this.m_Channel = this.m_Connection.createChannel();
                if (this.m_Channel == null) {
                    result = "Failed to create a channel!";
                } else {
                    this.m_Channel.basicQos(this.m_PrefetchCount);
                }
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to create channel!", (Throwable)e);
            }
        }
        return result;
    }

    protected void disconnect() {
        RabbitMQHelper.closeQuietly(this.m_Channel);
        RabbitMQHelper.closeQuietly(this.m_Connection);
        this.m_Channel = null;
        this.m_Connection = null;
    }

    protected Channel getChannel() {
        if (this.m_Channel == null) {
            this.connect();
        }
        return this.m_Channel;
    }

    protected String doSend(RemoteCommand cmd, RemoteCommandProcessor processor) {
        String result = null;
        if (this.m_Channel == null) {
            result = this.connect();
        }
        String msg = null;
        if (result == null) {
            if (cmd.isRequest()) {
                msg = cmd.assembleRequest(processor);
            } else if (cmd instanceof RemoteCommandWithResponse) {
                msg = ((RemoteCommandWithResponse)cmd).assembleResponse(processor);
            } else {
                result = "Remote command is not a response but flagged as such:\n" + cmd.toString();
            }
        }
        byte[] data = null;
        MessageCollection errors = new MessageCollection();
        if (result == null) {
            if (msg == null) {
                result = "Failed to assemble message: " + cmd;
            } else {
                data = this.m_SendConverter.convert(msg, errors);
            }
        }
        if (data != null) {
            try {
                this.m_Channel.basicPublish(this.m_Exchange, this.m_Queue, null, data);
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to publish data (exchange=" + this.m_Exchange + ", queue=" + this.m_Queue + ")!"), (Throwable)e);
            }
        }
        return result;
    }

    protected String doSendRequest(RemoteCommand cmd, RemoteCommandProcessor processor) {
        return this.doSend(cmd, processor);
    }

    protected String doSendResponse(RemoteCommand cmd, RemoteCommandProcessor processor) {
        return this.doSend(cmd, processor);
    }

    public void cleanUp() {
        this.disconnect();
        super.cleanUp();
    }
}

