/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.engine;

import adams.core.MessageCollection;
import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.channelaction.AbstractChannelAction;
import adams.core.net.rabbitmq.channelaction.NoAction;
import adams.core.net.rabbitmq.connection.AbstractConnectionFactory;
import adams.core.net.rabbitmq.connection.GuestConnectionFactory;
import adams.core.net.rabbitmq.receive.AbstractConverter;
import adams.core.net.rabbitmq.receive.StringConverter;
import adams.multiprocess.PausableFixedThreadPoolExecutor;
import adams.scripting.command.RemoteCommand;
import adams.scripting.engine.AbstractScriptingEngineWithJobQueue;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DeliverCallback;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class RabbitMQScriptingEngine
extends AbstractScriptingEngineWithJobQueue {
    private static final long serialVersionUID = -3763240773922918567L;
    protected AbstractConnectionFactory m_ConnectionFactory;
    protected int m_PrefetchCount;
    protected AbstractChannelAction m_Action;
    protected String m_Exchange;
    protected String m_Queue;
    protected AbstractConverter m_Converter;
    protected transient Connection m_Connection;
    protected transient Channel m_Channel;
    protected ArrayBlockingQueue<Object> m_Data;
    protected ArrayBlockingQueue<Long> m_Tags;
    protected int m_PollTimeout;

    public String globalInfo() {
        return "Listens for commands using a RabbitMQ exchange or queue.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Data = null;
        this.m_Tags = null;
        this.m_PollTimeout = 100;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("connection-factory", "connectionFactory", (Object)new GuestConnectionFactory());
        this.m_OptionManager.add("prefetch-count", "prefetchCount", (Object)1, (Number)0, null);
        this.m_OptionManager.add("action", "action", (Object)new NoAction());
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("converter", "converter", (Object)new StringConverter());
    }

    public void setConnectionFactory(AbstractConnectionFactory value) {
        this.m_ConnectionFactory = value;
        this.reset();
    }

    public AbstractConnectionFactory getConnectionFactory() {
        return this.m_ConnectionFactory;
    }

    public String connectionFactoryTipText() {
        return "The connection factory to use.";
    }

    public void setPrefetchCount(int value) {
        this.m_PrefetchCount = value;
        this.reset();
    }

    public int getPrefetchCount() {
        return this.m_PrefetchCount;
    }

    public String prefetchCountTipText() {
        return "The number of un-acked jobs a client can pull off a queue; 0 = unlimited, 1 = fair.";
    }

    public void setAction(AbstractChannelAction value) {
        this.m_Action = value;
        this.reset();
    }

    public AbstractChannelAction getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The channel action to execute.";
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The converter to use.";
    }

    protected void close() {
        RabbitMQHelper.closeQuietly(this.m_Connection);
        RabbitMQHelper.closeQuietly(this.m_Channel);
        this.m_Channel = null;
        this.m_Connection = null;
    }

    protected String connect() {
        String result = null;
        MessageCollection errors = new MessageCollection();
        ConnectionFactory factory = this.m_ConnectionFactory.generate(errors);
        if (!errors.isEmpty()) {
            return null;
        }
        try {
            this.m_Connection = factory.newConnection();
            if (this.m_Connection == null) {
                result = "Failed to connect to broker (" + (Object)((Object)this.m_ConnectionFactory) + ")!";
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to connect to broker (" + (Object)((Object)this.m_ConnectionFactory) + ")!"), (Throwable)e);
        }
        if (result == null) {
            try {
                this.m_Channel = this.m_Connection.createChannel();
                if (this.m_Channel == null) {
                    result = "Failed to create a channel!";
                } else {
                    this.m_Channel.basicQos(this.m_PrefetchCount);
                }
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to create channel!", (Throwable)e);
            }
        }
        if (result == null) {
            result = this.m_Action.performAction(this.m_Channel);
        }
        return result;
    }

    protected void handleMessage(Object data, Long tag) {
        boolean ack = false;
        MessageCollection errors = new MessageCollection();
        RemoteCommand cmd = this.m_CommandProcessor.parse("" + data, errors);
        if (cmd != null) {
            if (!this.m_PermissionHandler.permitted(cmd)) {
                this.m_RequestHandler.requestRejected(cmd, "Not permitted!");
                return;
            }
            String msg = this.m_CommandHandler.handle(cmd, this.m_CommandProcessor);
            if (msg != null) {
                this.getLogger().severe("Failed to handle command:\n" + msg);
            } else {
                ack = true;
            }
        } else if (!errors.isEmpty()) {
            this.getLogger().severe("Failed to parse command:\n" + errors.toString());
        } else {
            this.getLogger().severe("Failed to parse command:\n" + data);
        }
        if (ack && tag != null) {
            try {
                this.m_Channel.basicAck(tag.longValue(), false);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to send ack!", (Throwable)e);
            }
        }
    }

    protected String doExecute() {
        this.m_Paused = false;
        this.m_Stopped = false;
        String result = this.connect();
        String queue = "";
        DeliverCallback deliverCallback = null;
        if (result == null) {
            if (this.m_Data == null) {
                this.m_Data = new ArrayBlockingQueue(65536);
                this.m_Tags = new ArrayBlockingQueue(65536);
            }
            this.m_Data.clear();
            this.m_Tags.clear();
            deliverCallback = (consumerTag, delivery) -> {
                byte[] recv = delivery.getBody();
                MessageCollection errors = new MessageCollection();
                Object output = this.m_Converter.convert(recv, errors);
                this.m_Tags.add(delivery.getEnvelope().getDeliveryTag());
                this.m_Data.add(output);
            };
            if (this.m_Exchange.isEmpty()) {
                queue = this.m_Queue;
            } else {
                try {
                    queue = this.m_Channel.queueDeclare().getQueue();
                    this.m_Channel.queueBind(queue, this.m_Exchange, "");
                }
                catch (Exception e) {
                    result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to bind queue to exchange!", (Throwable)e);
                }
            }
        }
        if (this.m_Channel != null) {
            this.m_Executor = new PausableFixedThreadPoolExecutor(this.m_MaxConcurrentJobs);
            while (!this.m_Stopped) {
                while (this.m_Paused && !this.m_Stopped) {
                    Utils.wait((LoggingSupporter)this, (StoppableWithFeedback)this, (int)1000, (int)50);
                }
                try {
                    this.m_Channel.basicConsume(queue, false, deliverCallback, consumerTag -> {});
                }
                catch (Exception e) {
                    result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to consume data!", (Throwable)e);
                }
                Object data = null;
                while (!this.isStopped() && data == null) {
                    try {
                        data = this.m_Data.poll(this.m_PollTimeout, TimeUnit.MILLISECONDS);
                        if (data == null) continue;
                        Long tag = this.m_Tags.poll();
                        if (tag == null) {
                            this.getLogger().severe("No tag for ack received");
                        }
                        this.handleMessage(data, tag);
                    }
                    catch (Exception e) {
                        if (!this.isLoggingEnabled()) continue;
                        this.getLogger().log(Level.INFO, "Exception while polling", (Throwable)e);
                    }
                }
            }
        }
        this.close();
        if (this.m_Executor != null && !this.m_Executor.isTerminated()) {
            this.getLogger().info("Shutting down job queue...");
            this.m_Executor.shutdown();
            while (!this.m_Executor.isTerminated()) {
                Utils.wait((LoggingSupporter)this, (int)1000, (int)100);
            }
            this.getLogger().info("Job queue shut down");
        }
        return result;
    }

    public void stopExecution() {
        super.stopExecution();
        this.close();
    }

    public static void main(String[] args) {
        RabbitMQScriptingEngine.runScriptingEngine(RabbitMQScriptingEngine.class, (String[])args);
    }
}

