/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.channelaction;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.channelaction.AbstractChannelActionWithWait;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.Channel;

public class DeclareQueue
extends AbstractChannelActionWithWait {
    private static final long serialVersionUID = 4097038378479166882L;
    protected String m_Queue;
    protected boolean m_Durable;
    protected boolean m_Exclusive;
    protected boolean m_AutoDelete;

    public String globalInfo() {
        return "Declares the specified queue.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("durable", "durable", (Object)false);
        this.m_OptionManager.add("exclusive", "exclusive", (Object)false);
        this.m_OptionManager.add("auto-delete", "autoDelete", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)"queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"durable", (boolean)this.m_Durable, (String)"durable", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"exclusive", (boolean)this.m_Exclusive, (String)"exclusive", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"autoDelete", (boolean)this.m_AutoDelete, (String)"auto-delete", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"wait", (boolean)this.m_Wait, (String)"wait", (String)", ");
        return result;
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setDurable(boolean value) {
        this.m_Durable = value;
        this.reset();
    }

    public boolean getDurable() {
        return this.m_Durable;
    }

    public String durableTipText() {
        return "If enabled, declaring a durable queue (the queue will survive a server restart).";
    }

    public void setExclusive(boolean value) {
        this.m_Exclusive = value;
        this.reset();
    }

    public boolean getExclusive() {
        return this.m_Exclusive;
    }

    public String exclusiveTipText() {
        return "If enabled, declaring an exclusive queue (restricted to this connection).";
    }

    public void setAutoDelete(boolean value) {
        this.m_AutoDelete = value;
        this.reset();
    }

    public boolean getAutoDelete() {
        return this.m_AutoDelete;
    }

    public String autoDeleteTipText() {
        return "If enabled, declaring an autodelete queue (server will delete it when no longer in use).";
    }

    @Override
    protected String doPerformAction(Channel channel) {
        String result = null;
        try {
            if (this.m_Wait) {
                channel.queueDeclare(this.m_Queue, this.m_Durable, this.m_Exclusive, this.m_AutoDelete, null);
            } else {
                channel.queueDeclareNoWait(this.m_Queue, this.m_Durable, this.m_Exclusive, this.m_AutoDelete, null);
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to declare queue '" + this.m_Queue + "'!"), (Throwable)e);
        }
        return result;
    }
}

