/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.channelaction;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.channelaction.AbstractChannelActionWithWait;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.Channel;

public class DeleteExchange
extends AbstractChannelActionWithWait {
    private static final long serialVersionUID = 4097038378479166882L;
    protected String m_Exchange;
    protected boolean m_IfUnused;

    public String globalInfo() {
        return "Deletes the specified exchange.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("if-unused", "ifUnused", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"exchange", (Object)(this.m_Exchange.isEmpty() ? "-empty-" : this.m_Exchange), (String)"exchange: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"ifUnused", (boolean)this.m_IfUnused, (String)"if unused", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"wait", (boolean)this.m_Wait, (String)"wait", (String)", ");
        return result;
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setIfUnused(boolean value) {
        this.m_IfUnused = value;
        this.reset();
    }

    public boolean getIfUnused() {
        return this.m_IfUnused;
    }

    public String ifUnusedTipText() {
        return "If enabled, only gets deleted if not used.";
    }

    @Override
    protected String doPerformAction(Channel channel) {
        String result = null;
        try {
            if (this.m_Wait) {
                channel.exchangeDelete(this.m_Exchange, this.m_IfUnused);
            } else {
                channel.exchangeDeleteNoWait(this.m_Exchange, this.m_IfUnused);
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to delete exchange '" + this.m_Exchange + "'!"), (Throwable)e);
        }
        return result;
    }
}

