/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.channelaction;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.channelaction.AbstractChannelAction;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.Channel;

public class PurgeQueue
extends AbstractChannelAction {
    private static final long serialVersionUID = 4097038378479166882L;
    protected String m_Queue;

    public String globalInfo() {
        return "Purges the specified queue.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("queue", "queue", (Object)"");
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)"queue: ");
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    @Override
    protected String doPerformAction(Channel channel) {
        String result = null;
        try {
            channel.queuePurge(this.m_Queue);
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to purge queue '" + this.m_Queue + "'!"), (Throwable)e);
        }
        return result;
    }
}

