/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.connection;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.net.rabbitmq.connection.AbstractConnectionFactory;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.ConnectionFactory;

public class GuestConnectionFactory
extends AbstractConnectionFactory {
    private static final long serialVersionUID = 1730696755155054710L;
    protected String m_Host;
    protected int m_Port;
    protected String m_VirtualHost;

    public String globalInfo() {
        return "Does not use any authentication.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"localhost");
        this.m_OptionManager.add("port", "port", (Object)5672, (Number)1, (Number)65535);
        this.m_OptionManager.add("virtual-host", "virtualHost", (Object)"/");
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)(this.m_Host.length() == 0 ? "??" : this.m_Host), (String)"guest@");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)":");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"virtualHost", (Object)this.m_VirtualHost, (String)"");
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to connect to.";
    }

    public void setVirtualHost(String value) {
        this.m_VirtualHost = value;
        this.reset();
    }

    public String getVirtualHost() {
        return this.m_VirtualHost;
    }

    public String virtualHostTipText() {
        return "The virtual host to use on the RabbitMQ server.";
    }

    @Override
    protected boolean requiresFlowContext() {
        return false;
    }

    @Override
    protected ConnectionFactory doGenerate(MessageCollection errors) {
        ConnectionFactory result = new ConnectionFactory();
        result.setHost(this.m_Host);
        result.setPort(this.m_Port);
        result.setVirtualHost(this.m_VirtualHost);
        return result;
    }
}

