/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.deliveryaction;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.deliveryaction.AbstractDeliveryAction;
import adams.core.option.OptionHandler;
import com.rabbitmq.client.Channel;
import java.util.ArrayList;

public class Reject
extends AbstractDeliveryAction {
    private static final long serialVersionUID = 4328085615118918815L;
    protected boolean m_Multiple;
    protected boolean m_Requeue;

    public String globalInfo() {
        return "Rejects the processing of the message with the specified delivery tag.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("multiple", "multiple", (Object)false);
        this.m_OptionManager.add("requeue", "requeue", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"multiple", (boolean)this.m_Multiple, (String)"multiple"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"requeue", (boolean)this.m_Requeue, (String)"requeue"));
        String result = QuickInfoHelper.flatten(options);
        return result;
    }

    public void setMultiple(boolean value) {
        this.m_Multiple = value;
        this.reset();
    }

    public boolean getMultiple() {
        return this.m_Multiple;
    }

    public String multipleTipText() {
        return "If enabled, rejects all messages up to and including the delivery tag.";
    }

    public void setRequeue(boolean value) {
        this.m_Requeue = value;
        this.reset();
    }

    public boolean getRequeue() {
        return this.m_Requeue;
    }

    public String requeueTipText() {
        return "If enabled, rejected messages get requeued again.";
    }

    @Override
    protected String doPerformAction(Channel channel, long tag) {
        try {
            channel.basicAck(tag, this.m_Multiple);
            return null;
        }
        catch (Exception e) {
            return LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to reject tag " + tag + " (multiple=" + this.m_Multiple + ", requeue=" + this.m_Requeue + ")!"), (Throwable)e);
        }
    }
}

