/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net.rabbitmq.receive;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseURL;
import adams.core.net.rabbitmq.receive.AbstractConverter;
import adams.core.net.rabbitmq.receive.BinaryConverter;
import adams.core.net.rabbitmq.receive.StringConverter;
import adams.core.option.OptionHandler;
import adams.flow.container.HttpRequestResult;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.rest.dex.DataExchangeHelper;
import adams.flow.rest.dex.clientauthentication.AbstractClientAuthentication;
import adams.flow.rest.dex.clientauthentication.NoAuthentication;
import adams.flow.standalone.DataExchangeServerConnection;

public class DataExchangeServerBasedConverter
extends AbstractConverter {
    private static final long serialVersionUID = -736244897402323379L;
    protected AbstractConverter m_Converter;
    protected boolean m_UseFlowContextConnection;
    protected transient DataExchangeServerConnection m_Connection;
    protected BaseURL m_Server;
    protected AbstractClientAuthentication m_Authentication;
    protected boolean m_Remove;
    protected transient BaseURL m_ActualDownloadURL;
    protected transient BaseURL m_ActualRemoveURL;
    protected AbstractClientAuthentication m_ActualAuthentication;

    public String globalInfo() {
        return "Instead of sending potentially large payloads via a RabbitMQ, this meta-converter loads the actual payload from the specified data exchange server using the token received via RabbitMQ.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("converter", "converter", (Object)new BinaryConverter());
        this.m_OptionManager.add("use-flow-context-connection", "useFlowContextConnection", (Object)false);
        this.m_OptionManager.add("server", "server", (Object)new BaseURL("http://localhost:8080/"));
        this.m_OptionManager.add("authentication", "authentication", (Object)new NoAuthentication());
        this.m_OptionManager.add("remove", "remove", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)((Object)this.m_Converter), (String)"converter: ");
        if (this.m_UseFlowContextConnection) {
            result = result + ", connection from flow context";
        } else {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"server", (Object)this.m_Server, (String)", server: ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"authentication", (Object)((Object)this.m_Authentication), (String)", auth: ");
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"remove", (Object)(this.m_Remove ? "remove" : "leave"), (String)", data: ");
        return result;
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The base converter for performing the actual conversion.";
    }

    public void setUseFlowContextConnection(boolean value) {
        this.m_UseFlowContextConnection = value;
        this.reset();
    }

    public boolean getUseFlowContextConnection() {
        return this.m_UseFlowContextConnection;
    }

    public String useFlowContextConnectionTipText() {
        return "If enabled, the data exchange server connection available through the flow context is used rather than the server/authentication defined here.";
    }

    public void setServer(BaseURL value) {
        this.m_Server = value;
        this.reset();
    }

    public BaseURL getServer() {
        return this.m_Server;
    }

    public String serverTipText() {
        return "The data exchange server to use.";
    }

    public void setAuthentication(AbstractClientAuthentication value) {
        this.m_Authentication = value;
        this.reset();
    }

    public AbstractClientAuthentication getAuthentication() {
        return this.m_Authentication;
    }

    public String authenticationTipText() {
        return "The authentication to use for accessing the server.";
    }

    public void setRemove(boolean value) {
        this.m_Remove = value;
        this.reset();
    }

    public boolean getRemove() {
        return this.m_Remove;
    }

    public String removeTipText() {
        return "If enabled, the data gets removed after successfully retrieving it.";
    }

    @Override
    public Class generates() {
        return this.m_Converter.generates();
    }

    @Override
    public String check(byte[] payload) {
        String result = super.check(payload);
        if (result == null && this.m_UseFlowContextConnection && this.m_Connection == null) {
            this.m_Connection = (DataExchangeServerConnection)ActorUtils.findClosestType((Actor)this.getFlowContext(), DataExchangeServerConnection.class);
            if (this.m_Connection == null) {
                result = "No " + DataExchangeServerConnection.class.getName() + " actor found!";
            }
        }
        if (result == null && this.m_ActualDownloadURL == null) {
            if (this.m_Connection != null) {
                this.m_ActualDownloadURL = this.m_Connection.buildURL("download");
                this.m_ActualRemoveURL = this.m_Connection.buildURL("remove");
                this.m_ActualAuthentication = this.m_Connection.getAuthentication();
            } else {
                this.m_ActualDownloadURL = DataExchangeHelper.buildURL(this.m_Server, "download");
                this.m_ActualRemoveURL = DataExchangeHelper.buildURL(this.m_Server, "remove");
                this.m_ActualAuthentication = this.m_Authentication;
                this.m_ActualAuthentication.setFlowContext(this.getFlowContext());
            }
        }
        return result;
    }

    @Override
    protected Object doConvert(byte[] payload, MessageCollection errors) {
        String token = (String)new StringConverter().convert(payload, errors);
        if (!errors.isEmpty()) {
            return null;
        }
        byte[] data = DataExchangeHelper.download(token, this.m_ActualDownloadURL, this.m_ActualAuthentication, errors);
        Object result = errors.isEmpty() && data != null ? this.m_Converter.convert(data, errors) : null;
        if (result != null && this.m_Remove) {
            errors.clear();
            HttpRequestResult response = DataExchangeHelper.remove(token, this.m_ActualRemoveURL, this.m_ActualAuthentication, errors);
            if (response != null && (Integer)response.getValue("Status code", Integer.class) != 200) {
                errors.add("Failed to remove data for token '" + token + "': " + response);
            }
        }
        return result;
    }
}

