/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.VariableName;
import adams.flow.container.EncapsulatedActorsContainer;
import adams.flow.control.AbstractRabbitMQControlActor;
import adams.flow.control.StorageName;
import adams.flow.control.Tee;
import adams.flow.core.Actor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.EncapsulateActors;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Unknown;
import com.rabbitmq.client.DeliverCallback;

public class RabbitMQRemoteTee
extends AbstractRabbitMQControlActor
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 5816569944356142679L;

    public String globalInfo() {
        return "Encapsulates a sequence of actors to be executed remotely as a Tee. The first actor must accept input.";
    }

    @Override
    protected String checkSubActor(int index, Actor actor) {
        if (ActorUtils.isSource((Actor)actor)) {
            return "You cannot add a source actor ('" + actor.getName() + "'/" + actor.getClass().getName() + ")!";
        }
        return null;
    }

    @Override
    protected String checkSubActors(Actor[] actors) {
        if (actors.length > 0) {
            for (int i = 0; i < actors.length; ++i) {
                if (actors[i].getSkip() || actors[i] instanceof InputConsumer) continue;
                return "You need to provide an actor that processes input, '" + actors[i].getName() + "'/" + actors[i].getClass().getName() + " doesn't!";
            }
        }
        return null;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo().allowStandalones(false).allowSource(false).actorExecution(ActorExecution.SEQUENTIAL).forwardsInput(true);
    }

    public Class[] accepts() {
        if (this.active() > 0) {
            return ((InputConsumer)this.firstActive()).accepts();
        }
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && !(this.firstActive() instanceof InputConsumer)) {
            result = "First actor ('" + this.firstActive().getName() + "') does not accept input!";
        }
        return result;
    }

    @Override
    protected EncapsulatedActorsContainer encapsulate() {
        Tee sub = new Tee();
        sub.setName("source: " + this.getFullName());
        for (int i = 0; i < this.size(); ++i) {
            sub.add(this.get(i).shallowCopy(false));
        }
        sub.setParent(this.getParent());
        sub.setVariables(this.getVariables());
        return EncapsulateActors.wrap((Actor)sub, (VariableName[])this.m_VariableNames, (StorageName[])this.m_StorageNames, (Object)this.m_InputToken.getPayload());
    }

    @Override
    protected DeliverCallback generateDeliverCallback() {
        DeliverCallback result = (consumerTag, delivery) -> {
            this.m_OutputToken = this.m_InputToken;
            this.m_Processing = null;
        };
        return result;
    }
}

