/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex;

import adams.core.MessageCollection;
import adams.core.base.BaseKeyValuePair;
import adams.core.base.BaseURL;
import adams.flow.container.HttpRequestResult;
import adams.flow.rest.dex.DataExchange;
import adams.flow.rest.dex.clientauthentication.AbstractClientAuthentication;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.core.MediaTypeHelper;
import com.github.fracpete.requests4j.request.Request;
import com.github.fracpete.requests4j.response.BasicResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class DataExchangeHelper {
    protected static Request initRequest(BaseURL server, AbstractClientAuthentication auth, MessageCollection errors) {
        BaseKeyValuePair[] authPairs = auth.generate(errors);
        if (!errors.isEmpty()) {
            return null;
        }
        Request result = Requests.post((URL)server.urlValue());
        for (BaseKeyValuePair authPair : authPairs) {
            result.formData().add(authPair.getPairKey(), authPair.getPairValue());
        }
        return result;
    }

    public static String upload(File file, BaseURL server, AbstractClientAuthentication auth, MessageCollection errors) {
        Request request = DataExchangeHelper.initRequest(server, auth, errors);
        if (request == null) {
            return null;
        }
        try {
            request.formData().addFile("payload", file.getAbsolutePath());
            BasicResponse response = request.execute();
            if (response.statusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                DataExchange.TokenMessage tokenMsg = (DataExchange.TokenMessage)mapper.readValue("" + response.text(), DataExchange.TokenMessage.class);
                return tokenMsg.getToken();
            }
            errors.add("Status code: " + response.statusCode());
            errors.add("Status message: " + response.statusMessage());
            errors.add("Body: " + response.text());
        }
        catch (Exception e) {
            errors.add("Failed to upload file '" + file + "' to: " + server, (Throwable)e);
        }
        return null;
    }

    public static String upload(byte[] data, BaseURL server, AbstractClientAuthentication auth, MessageCollection errors) {
        Request request = DataExchangeHelper.initRequest(server, auth, errors);
        if (request == null) {
            return null;
        }
        try {
            request.formData().addStream("payload", "data.ser", MediaTypeHelper.OCTECT_STREAM, (InputStream)new ByteArrayInputStream(data));
            BasicResponse response = request.execute();
            if (response.statusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                DataExchange.TokenMessage tokenMsg = (DataExchange.TokenMessage)mapper.readValue("" + response.text(), DataExchange.TokenMessage.class);
                return tokenMsg.getToken();
            }
            errors.add("Status code: " + response.statusCode());
            errors.add("Status message: " + response.statusMessage());
            errors.add("Body: " + response.text());
        }
        catch (Exception e) {
            errors.add("Failed to upload data to: " + server, (Throwable)e);
        }
        return null;
    }

    public static byte[] download(String token, BaseURL server, AbstractClientAuthentication auth, MessageCollection errors) {
        Request request = DataExchangeHelper.initRequest(server, auth, errors);
        if (request == null) {
            return null;
        }
        try {
            request.formData().add("token", token);
            BasicResponse response = request.execute();
            if (response.statusCode() == 200) {
                return response.body();
            }
            errors.add("Failed to download data with token '" + token + "' from server '" + server + "': " + response);
            return null;
        }
        catch (Exception e) {
            errors.add("Failed to download data with token '" + token + "' from: " + server, (Throwable)e);
            return null;
        }
    }

    public static HttpRequestResult remove(String token, BaseURL server, AbstractClientAuthentication auth, MessageCollection errors) {
        Request request = DataExchangeHelper.initRequest(server, auth, errors);
        if (request == null) {
            return null;
        }
        try {
            request.formData().add("token", token);
            BasicResponse response = request.execute();
            return new HttpRequestResult(response.statusCode(), response.statusMessage(), response.text());
        }
        catch (Exception e) {
            errors.add("Failed to remove data with token '" + token + "' from: " + server, (Throwable)e);
            return null;
        }
    }

    public static BaseURL buildURL(BaseURL server, String path) {
        String url;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!(url = server.getValue()).endsWith("/")) {
            url = url + "/";
        }
        url = url + path;
        return new BaseURL(url);
    }
}

