/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex;

import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.rest.AbstractRESTProvider;
import adams.flow.rest.dex.DataExchange;
import adams.flow.rest.dex.authentication.AbstractAuthentication;
import adams.flow.rest.dex.authentication.NoAuthenticationRequired;
import adams.flow.rest.dex.backend.AbstractBackend;
import adams.flow.rest.dex.backend.InMemory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;

public class DataExchangeServer
extends AbstractRESTProvider {
    private static final long serialVersionUID = 2978764775645037701L;
    protected AbstractAuthentication m_Authentication;
    protected AbstractBackend m_Backend;

    public String globalInfo() {
        return "Only offers: " + Utils.classToString(DataExchange.class) + "\n\n" + new DataExchange().getAdditionalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("authentication", "authentication", (Object)new NoAuthenticationRequired());
        this.m_OptionManager.add("backend", "backend", (Object)new InMemory());
    }

    public void setAuthentication(AbstractAuthentication value) {
        this.m_Authentication = value;
        this.reset();
    }

    public AbstractAuthentication getAuthentication() {
        return this.m_Authentication;
    }

    public String authenticationTipText() {
        return "The scheme to use for authenticating clients.";
    }

    public void setBackend(AbstractBackend value) {
        this.m_Backend = value;
        this.reset();
    }

    public AbstractBackend getBackend() {
        return this.m_Backend;
    }

    public String backendTipText() {
        return "The scheme to use for managing the uploaded data.";
    }

    public String getDefaultURL() {
        return "http://localhost:8080/";
    }

    protected Server doStart() throws Exception {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        this.configureInterceptors(factory);
        DataExchange exchange = new DataExchange();
        exchange.setAuthentication((AbstractAuthentication)OptionUtils.shallowCopy((OptionHandler)this.m_Authentication, (boolean)true));
        exchange.setBackend((AbstractBackend)OptionUtils.shallowCopy((OptionHandler)this.m_Backend, (boolean)true));
        exchange.setLoggingLevel(this.getLoggingLevel());
        factory.setServiceBean((Object)exchange);
        factory.setAddress(this.getURL());
        this.configureTLS(factory);
        return factory.create();
    }
}

