/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex.authentication;

import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.base.BaseString;
import adams.flow.rest.dex.authentication.AbstractAuthentication;
import java.util.HashMap;
import java.util.Map;

public class BasicAuthentication
extends AbstractAuthentication {
    private static final long serialVersionUID = -7676121366240447918L;
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    protected BaseString[] m_Users;
    protected BasePassword[] m_Passwords;
    protected transient Map<String, String> m_Lookup;

    public String globalInfo() {
        return "Matches the user (key: user) and password (key: password) obtained from the parameters against the provided users/passwords.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(KEY_USER, "users", (Object)new BaseString[0]);
        this.m_OptionManager.add(KEY_PASSWORD, "passwords", (Object)new BasePassword[0]);
    }

    public void setUsers(BaseString[] value) {
        this.m_Users = value;
        this.m_Passwords = (BasePassword[])Utils.adjustArray((Object)this.m_Passwords, (int)this.m_Users.length, (Object)new BasePassword());
        this.reset();
    }

    public BaseString[] getUsers() {
        return this.m_Users;
    }

    public String usersTipText() {
        return "The names of the users that can connect.";
    }

    public void setPasswords(BasePassword[] value) {
        this.m_Passwords = value;
        this.m_Users = (BaseString[])Utils.adjustArray((Object)this.m_Users, (int)this.m_Passwords.length, (Object)new BaseString());
        this.reset();
    }

    public BasePassword[] getPasswords() {
        return this.m_Passwords;
    }

    public String passwordsTipText() {
        return "The passwords for the users.";
    }

    @Override
    protected String doAuthenticate(Map<String, String> params) {
        if (this.m_Lookup == null) {
            this.m_Lookup = new HashMap<String, String>();
            for (int i = 0; i < this.m_Users.length; ++i) {
                this.m_Lookup.put(this.m_Users[i].getValue(), this.m_Passwords[i].getValue());
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("users/passwords: " + this.m_Lookup);
            }
        }
        if (!params.containsKey(KEY_USER)) {
            return "User parameter missing: user";
        }
        if (!params.containsKey(KEY_PASSWORD)) {
            return "Password parameter missing: password";
        }
        if (this.m_Lookup.containsKey(params.get(KEY_USER)) && this.m_Lookup.get(params.get(KEY_USER)).equals(params.get(KEY_PASSWORD))) {
            return null;
        }
        return "Invalid user/password!";
    }
}

