/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.dex.backend;

import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.io.lister.LocalDirectoryLister;
import adams.core.logging.CustomLoggingLevelObject;
import adams.flow.rest.dex.backend.AbstractBackend;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class FileBased
extends AbstractBackend {
    private static final long serialVersionUID = 918572755476028354L;
    protected PlaceholderDirectory m_DataDir;
    protected Map<String, DataContainer> m_Storage;

    public String globalInfo() {
        return "Stores the data on disk in the specified directory (\"<token>-<expiry>.ser\").";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-dir", "dataDir", (Object)new PlaceholderDirectory());
    }

    public void setDataDir(PlaceholderDirectory value) {
        this.m_DataDir = value;
        this.reset();
    }

    public PlaceholderDirectory getDataDir() {
        return this.m_DataDir;
    }

    public String dataDirTipText() {
        return "The directory to store the data in.";
    }

    @Override
    protected String doInitBackend() {
        this.m_Storage = new HashMap<String, DataContainer>();
        LocalDirectoryLister lister = new LocalDirectoryLister();
        lister.setListFiles(true);
        lister.setListDirs(false);
        lister.setRecursive(false);
        lister.setWatchDir(this.m_DataDir.getAbsolutePath());
        lister.setRegExp(new BaseRegExp(".*-[0-9]+\\.ser"));
        String[] files = lister.list();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Loading " + files.length + " files from " + this.m_DataDir);
        }
        for (String file : files) {
            PlaceholderFile phfile = new PlaceholderFile(file);
            String token = phfile.getName().replaceAll("-.*", "");
            String expiry = phfile.getName().replaceAll(".*-", "").replace(".ser", "");
            if (Utils.isLong((String)expiry)) {
                DataContainer cont = new DataContainer((File)phfile, new Date(Long.parseLong(expiry)));
                this.m_Storage.put(token, cont);
                continue;
            }
            this.getLogger().warning("File does not conform to format: <token>-<expiry>.ser");
        }
        return null;
    }

    @Override
    protected void doClear() {
        this.m_Storage.clear();
    }

    @Override
    protected void doPurge() {
        if (this.m_Storage.size() == 0) {
            return;
        }
        ArrayList<String> expired = new ArrayList<String>();
        for (String key : this.m_Storage.keySet()) {
            if (!this.m_Storage.get(key).hasExpired()) continue;
            expired.add(key);
        }
        if (expired.size() > 0) {
            for (String key : expired) {
                DataContainer cont = this.m_Storage.get(key);
                if (!cont.getFile().delete()) {
                    this.getLogger().warning("Failed to purge file: " + cont.getFile());
                }
                this.m_Storage.remove(key);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Purged: " + Utils.flatten(expired, (String)", "));
            }
        }
    }

    @Override
    protected boolean hasItem(String token) {
        return this.m_Storage.containsKey(token);
    }

    @Override
    protected byte[] getItem(String token) {
        DataContainer cont = this.m_Storage.get(token);
        if (cont != null) {
            return cont.getData();
        }
        return null;
    }

    @Override
    protected String addItem(byte[] data) {
        String result = this.nextToken();
        long expiry = System.currentTimeMillis() + (long)(this.m_TimeToLive * 1000);
        PlaceholderFile file = new PlaceholderFile(this.m_DataDir.getAbsolutePath() + File.separator + result + "-" + expiry + ".ser");
        DataContainer cont = new DataContainer(data, (File)file, new Date(expiry));
        this.m_Storage.put(result, cont);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data added: token=" + result + ", expiry=" + cont.getExpiry());
        }
        return result;
    }

    @Override
    protected boolean removeItem(String token) {
        DataContainer removed = this.m_Storage.remove(token);
        if (removed != null) {
            if (removed.getFile().delete()) {
                this.getLogger().info("Removed: " + removed.getFile());
            } else {
                this.getLogger().warning("Failed to remove: " + removed.getFile());
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Data removed: " + token);
        }
        return removed != null;
    }

    public static class DataContainer
    extends CustomLoggingLevelObject {
        private static final long serialVersionUID = 1379234889822596730L;
        protected File m_File;
        protected Date m_Expiry;

        public DataContainer(File file, Date expiry) {
            this.m_File = file;
            this.m_Expiry = expiry;
        }

        public DataContainer(byte[] data, File file, Date expiry) {
            this(file, expiry);
            try {
                SerializationHelper.write((String)file.getAbsolutePath(), (Object)data);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to write data to: " + file, (Throwable)e);
            }
        }

        public File getFile() {
            return this.m_File;
        }

        public byte[] getData() {
            if (!this.m_File.exists() || this.m_File.isDirectory()) {
                return null;
            }
            try {
                return (byte[])SerializationHelper.read((String)this.m_File.getAbsolutePath());
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to read data from: " + this.m_File, (Throwable)e);
                return null;
            }
        }

        public Date getExpiry() {
            return this.m_Expiry;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() >= this.m_Expiry.getTime();
        }
    }
}

