/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sendnotification;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.net.rabbitmq.send.StringConverter;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.sendnotification.AbstractNotification;
import adams.flow.standalone.RabbitMQConnection;
import com.rabbitmq.client.Channel;

public class RabbitMQPublish
extends AbstractNotification {
    private static final long serialVersionUID = -5909332155508918514L;
    protected String m_Exchange;
    protected String m_Queue;
    protected transient RabbitMQConnection m_Connection;
    protected transient Channel m_Channel;

    public String globalInfo() {
        return "Publishes the incoming message using the specified exchange or queue.\nNormally, when using an exchange, leave queue empty, and when using a queue, leave the exchange empty.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("queue", "queue", (Object)"");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"exchange", (Object)(this.m_Exchange.isEmpty() ? "-empty-" : this.m_Exchange), (String)"exchange: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)", queue: ");
        return result;
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    protected String check(String msg) {
        String result = super.check(msg);
        if (result == null && this.m_Connection == null) {
            this.m_Connection = (RabbitMQConnection)ActorUtils.findClosestType((Actor)this.m_FlowContext, RabbitMQConnection.class);
            if (this.m_Connection == null) {
                result = "No " + RabbitMQConnection.class.getName() + " actor found!";
            }
        }
        if (result == null && this.m_Channel == null) {
            this.m_Channel = this.m_Connection.createChannel();
            if (this.m_Channel == null) {
                result = "Failed to create a channel!";
            }
        }
        return result;
    }

    protected String doSendNotification(String msg) {
        String result = null;
        MessageCollection errors = new MessageCollection();
        StringConverter conv = new StringConverter();
        byte[] data = conv.convert(msg, errors);
        if (!errors.isEmpty()) {
            result = errors.toString();
        }
        if (result == null) {
            try {
                this.m_Channel.basicPublish(this.m_Exchange, this.m_Queue, null, data);
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to publish data (exchange=" + this.m_Exchange + ", queue=" + this.m_Queue + ")!"), (Throwable)e);
            }
        }
        return result;
    }
}

