/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.ClassCrossReference;
import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.receive.AbstractConverter;
import adams.core.net.rabbitmq.receive.StringConverter;
import adams.core.option.OptionHandler;
import adams.data.conversion.RabbitMQEnvelopeToMap;
import adams.flow.container.RabbitMQConsumptionContainer;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.sink.RabbitMQMessageDeliveryAction;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.RabbitMQChannelAction;
import adams.flow.standalone.RabbitMQConnection;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DeliverCallback;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class RabbitMQConsume
extends AbstractSource
implements ClassCrossReference {
    private static final long serialVersionUID = -7073183797972945731L;
    public static final String BACKUP_DATA = "data";
    protected String m_Exchange;
    protected String m_Queue;
    protected boolean m_AutoAck;
    protected AbstractConverter m_Converter;
    protected int m_Limit;
    protected boolean m_OutputContainer;
    protected transient RabbitMQConnection m_Connection;
    protected transient Channel m_Channel;
    protected ArrayBlockingQueue<Object> m_Data;
    protected int m_PollTimeout;

    public String globalInfo() {
        return "Consumes data it receives and forwards it.\nIt either binds to the specified exchange (if non-empty and ignores the queue name), or it listens to the specified queue.\nWhen using an exchange, this one must be declared via the " + Utils.classToString(RabbitMQChannelAction.class) + " standalone.\nWhen not automatically acknowledging messages, the delivery tag must be retrieved from the delivery envelope (enabled to output container) and manually acknowledge using " + Utils.classToString(RabbitMQMessageDeliveryAction.class) + ".";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{RabbitMQEnvelopeToMap.class, RabbitMQMessageDeliveryAction.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("auto-ack", "autoAck", (Object)true);
        this.m_OptionManager.add("converter", "converter", (Object)new StringConverter());
        this.m_OptionManager.add("limit", "limit", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("output-container", "outputContainer", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Data = null;
        this.m_PollTimeout = 100;
    }

    protected void reset() {
        super.reset();
        this.m_Data = null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_DATA);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Data != null) {
            result.put(BACKUP_DATA, this.m_Data);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_DATA)) {
            this.m_Data = (ArrayBlockingQueue)state.get(BACKUP_DATA);
            state.remove(BACKUP_DATA);
        }
        super.restoreState(state);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"exchange", (Object)(this.m_Exchange.isEmpty() ? "-empty-" : this.m_Exchange), (String)"exchange: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)", queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"autoAck", (boolean)this.m_AutoAck, (String)"auto-ack", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)((Object)this.m_Converter), (String)", converter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"limit", (Object)this.m_Limit, (String)", limit: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputContainer", (boolean)this.m_OutputContainer, (String)"container", (String)", ");
        return result;
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setAutoAck(boolean value) {
        this.m_AutoAck = value;
        this.reset();
    }

    public boolean getAutoAck() {
        return this.m_AutoAck;
    }

    public String autoAckTipText() {
        return "If enabled, jobs are automatically acknowledged (= flagged as successfully processed); otherwise the delivery tag has get extracted with " + Utils.classToString(RabbitMQEnvelopeToMap.class) + " and manually acknowledged using " + Utils.classToString(RabbitMQMessageDeliveryAction.class) + ".";
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The converter to use.";
    }

    public void setLimit(int value) {
        if (value <= 0) {
            value = -1;
        }
        this.m_Limit = value;
        this.reset();
    }

    public int getLimit() {
        return this.m_Limit;
    }

    public String limitTipText() {
        return "The limit for data objects received; use <= 0 for unlimited size.";
    }

    public void setOutputContainer(boolean value) {
        this.m_OutputContainer = value;
        this.reset();
    }

    public boolean getOutputContainer() {
        return this.m_OutputContainer;
    }

    public String outputContainerTipText() {
        return "If enabled, outputs the data along side any properties in a " + Utils.classToString(RabbitMQConsumptionContainer.class) + ".";
    }

    public Class[] generates() {
        if (this.m_OutputContainer) {
            return new Class[]{RabbitMQConsumptionContainer.class};
        }
        return new Class[]{this.m_Converter.generates()};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (RabbitMQConnection)ActorUtils.findClosestType((Actor)this, RabbitMQConnection.class);
            if (this.m_Connection == null) {
                result = "No " + RabbitMQConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        this.m_Converter.setFlowContext((Actor)this);
        if (this.m_Channel == null) {
            this.m_Channel = this.m_Connection.createChannel();
            if (this.m_Channel == null) {
                result = "Failed to create a channel!";
            }
        }
        String queue = "";
        DeliverCallback deliverCallback = null;
        if (result == null) {
            if (this.m_Data == null) {
                this.m_Data = new ArrayBlockingQueue(this.m_Limit < 1 ? 65536 : this.m_Limit);
            }
            this.m_Data.clear();
            deliverCallback = (consumerTag, delivery) -> {
                byte[] data = delivery.getBody();
                MessageCollection errors = new MessageCollection();
                Object output = this.m_Converter.convert(data, errors);
                if (this.m_OutputContainer) {
                    this.m_Data.add((Object)new RabbitMQConsumptionContainer(output, delivery.getProperties(), delivery.getEnvelope(), this.m_Channel));
                } else {
                    this.m_Data.add(output);
                }
            };
            if (this.m_Exchange.isEmpty()) {
                queue = this.m_Queue;
            } else {
                try {
                    queue = this.m_Channel.queueDeclare().getQueue();
                    this.m_Connection.addAutoCreatedQueue(queue);
                    this.m_Channel.queueBind(queue, this.m_Exchange, "");
                }
                catch (Exception e) {
                    result = this.handleException("Failed to bind queue to exchange!", e);
                }
            }
        }
        if (result == null) {
            try {
                this.m_Channel.basicConsume(queue, this.m_AutoAck, deliverCallback, consumerTag -> {});
            }
            catch (Exception e) {
                result = this.handleException("Failed to consume data!", e);
            }
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Executed && !this.isStopped();
    }

    public Token output() {
        Token result = null;
        Object data = null;
        while (!this.isStopped() && data == null) {
            try {
                data = this.m_Data.poll(this.m_PollTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().log(Level.INFO, "Exception while polling", (Throwable)e);
            }
        }
        if (data != null) {
            result = new Token(data);
        }
        return result;
    }

    public void wrapUp() {
        RabbitMQHelper.closeQuietly(this.m_Channel);
        this.m_Channel = null;
        this.m_Connection = null;
        super.wrapUp();
    }
}

