/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseURL;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.rest.dex.DataExchangeHelper;
import adams.flow.rest.dex.clientauthentication.AbstractClientAuthentication;
import adams.flow.rest.dex.clientauthentication.NoAuthentication;
import adams.flow.standalone.AbstractStandalone;

public class DataExchangeServerConnection
extends AbstractStandalone {
    private static final long serialVersionUID = -1726172998200420556L;
    protected BaseURL m_Server;
    protected AbstractClientAuthentication m_Authentication;

    public String globalInfo() {
        return "Defines a connection to a Data Exchange server.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("server", "server", (Object)new BaseURL("http://localhost:8080/"));
        this.m_OptionManager.add("authentication", "authentication", (Object)new NoAuthentication());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"server", (Object)this.m_Server, (String)"server: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"authentication", (Object)((Object)this.m_Authentication), (String)", auth: ");
        return result;
    }

    public void setServer(BaseURL value) {
        this.m_Server = value;
        this.reset();
    }

    public BaseURL getServer() {
        return this.m_Server;
    }

    public String serverTipText() {
        return "The data exchange server to use.";
    }

    public void setAuthentication(AbstractClientAuthentication value) {
        this.m_Authentication = value;
        this.reset();
    }

    public AbstractClientAuthentication getAuthentication() {
        return this.m_Authentication;
    }

    public String authenticationTipText() {
        return "The authentication to use for accessing the server.";
    }

    public BaseURL buildURL(String path) {
        return DataExchangeHelper.buildURL(this.m_Server, path);
    }

    protected String doExecute() {
        this.m_Authentication.setFlowContext((Actor)this);
        return null;
    }
}

