/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.channelaction.AbstractChannelAction;
import adams.core.net.rabbitmq.channelaction.DeclareQueue;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.RabbitMQConnection;
import com.rabbitmq.client.Channel;

public class RabbitMQChannelAction
extends AbstractStandalone {
    private static final long serialVersionUID = -132045002653940359L;
    protected AbstractChannelAction m_Action;
    protected transient RabbitMQConnection m_Connection;
    protected transient Channel m_Channel;

    public String globalInfo() {
        return "Executes the selected RabbitMQ channel action.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "action", (Object)new DeclareQueue());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"action", (Object)((Object)this.m_Action));
    }

    public void setAction(AbstractChannelAction value) {
        this.m_Action = value;
        this.reset();
    }

    public AbstractChannelAction getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The channel action to execute.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (RabbitMQConnection)ActorUtils.findClosestType((Actor)this, RabbitMQConnection.class);
            if (this.m_Connection == null) {
                result = "No " + RabbitMQConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Channel == null) {
            this.m_Channel = this.m_Connection.createChannel();
            if (this.m_Channel == null) {
                result = "Failed to create a channel!";
            }
        }
        if (result == null) {
            try {
                result = this.m_Action.performAction(this.m_Channel);
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute remote command: " + (Object)((Object)this.m_Action), e);
            }
        }
        return result;
    }

    public void wrapUp() {
        RabbitMQHelper.closeQuietly(this.m_Channel);
        this.m_Channel = null;
        this.m_Connection = null;
        super.wrapUp();
    }
}

