/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.flow.core.Token;
import adams.flow.rest.dex.DataExchangeHelper;
import adams.flow.standalone.DataExchangeServerConnection;
import adams.flow.transformer.AbstractDataExchangeServerTransformer;

public class DataExchangeServerDownload
extends AbstractDataExchangeServerTransformer {
    private static final long serialVersionUID = 5538665246033999366L;

    public String globalInfo() {
        return "Downloads the data associated with the incoming token and forwards it as byte array, if successful.\nUses the " + Utils.classToString(DataExchangeServerConnection.class) + " available to this actor.";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{byte[].class};
    }

    @Override
    protected String getPath() {
        return "download";
    }

    protected String doExecute() {
        String result = null;
        String token = (String)this.m_InputToken.getPayload(String.class);
        MessageCollection errors = new MessageCollection();
        byte[] data = DataExchangeHelper.download(token, this.getActualUrl(), this.m_Connection.getAuthentication(), errors);
        if (errors.isEmpty() && data != null) {
            this.m_OutputToken = new Token((Object)data);
        } else if (!errors.isEmpty()) {
            result = errors.toString();
        }
        return result;
    }
}

