/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.flow.container.HttpRequestResult;
import adams.flow.core.Token;
import adams.flow.rest.dex.DataExchangeHelper;
import adams.flow.standalone.DataExchangeServerConnection;
import adams.flow.transformer.AbstractDataExchangeServerTransformer;
import java.io.File;

public class DataExchangeServerRemove
extends AbstractDataExchangeServerTransformer {
    private static final long serialVersionUID = 5538665246033999366L;

    public String globalInfo() {
        return "Removes the data associated with the incoming token and forwards the request result.\nUses the " + Utils.classToString(DataExchangeServerConnection.class) + " available to this actor.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{HttpRequestResult.class};
    }

    @Override
    protected String getPath() {
        return "remove";
    }

    protected String doExecute() {
        String result = null;
        String token = (String)this.m_InputToken.getPayload(String.class);
        MessageCollection errors = new MessageCollection();
        HttpRequestResult response = DataExchangeHelper.remove(token, this.getActualUrl(), this.m_Connection.getAuthentication(), errors);
        if (errors.isEmpty() && response != null) {
            this.m_OutputToken = new Token((Object)response);
        } else if (!errors.isEmpty()) {
            result = errors.toString();
        }
        return result;
    }
}

