/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.rest.dex.DataExchangeHelper;
import adams.flow.standalone.DataExchangeServerConnection;
import adams.flow.transformer.AbstractDataExchangeServerTransformer;
import java.io.File;

public class DataExchangeServerUpload
extends AbstractDataExchangeServerTransformer {
    private static final long serialVersionUID = 5538665246033999366L;

    public String globalInfo() {
        return "Uploads the file or byte array and forwards the received token, if successful.\nUses the " + Utils.classToString(DataExchangeServerConnection.class) + " available to this actor.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, byte[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String getPath() {
        return "upload";
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = null;
        byte[] data = new byte[]{};
        if (this.m_InputToken.hasPayload(String.class)) {
            file = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        } else if (this.m_InputToken.hasPayload(File.class)) {
            file = new PlaceholderFile((File)this.m_InputToken.getPayload(File.class));
        } else if (this.m_InputToken.hasPayload(byte[].class)) {
            data = (byte[])this.m_InputToken.getPayload(byte[].class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            MessageCollection errors = new MessageCollection();
            String token = file != null ? DataExchangeHelper.upload((File)file, this.getActualUrl(), this.m_Connection.getAuthentication(), errors) : DataExchangeHelper.upload(data, this.getActualUrl(), this.m_Connection.getAuthentication(), errors);
            if (errors.isEmpty() && token != null) {
                this.m_OutputToken = new Token((Object)token);
            } else if (!errors.isEmpty()) {
                result = errors.toString();
            }
        }
        return result;
    }
}

