/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.transformer.AbstractArraySplitter;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;

public class ArraySubSample
extends AbstractArraySplitter {
    private static final long serialVersionUID = 8536100625511019961L;
    protected double m_Size;

    public String globalInfo() {
        return "Generates a subset of the array, using a random sub-sample.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "size", (Object)1.0, (Number)0.0, null);
    }

    public void setSize(double value) {
        if (value > 0.0) {
            this.m_Size = value;
            this.reset();
        } else {
            this.getLogger().warning("Sample size must be >0, provided: " + value);
        }
    }

    public double getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size of the sample: 0-1 = percentage, >1 absolute number of elements.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"size", (Object)this.m_Size, (String)"size: ");
        result = result + ", " + super.getQuickInfo();
        return result;
    }

    protected String doExecute() {
        Object arrayNew;
        int i;
        String result = null;
        Object arrayOld = this.m_InputToken.getPayload();
        int size = this.m_Size <= 1.0 ? (int)Math.round((double)Array.getLength(arrayOld) * this.m_Size) : (int)this.m_Size;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Size of sample: " + size);
        }
        TIntArrayList available = new TIntArrayList();
        for (i = 0; i < Array.getLength(arrayOld); ++i) {
            available.add(i);
        }
        TIntArrayList indices = new TIntArrayList();
        this.m_Generator.setMinValue(0);
        while (size > 0) {
            if (available.size() == 1) {
                i = 0;
            } else {
                this.m_Generator.setMaxValue(available.size() - 1);
                i = this.m_Generator.next().intValue();
            }
            indices.add(available.get(i));
            available.removeAt(i);
            --size;
        }
        switch (this.m_SplitResult) {
            case SPLIT: {
                indices.sort();
                arrayNew = this.newArray(arrayOld, indices, "split");
                this.m_OutputToken = new Token(arrayNew);
                break;
            }
            case INVERSE: {
                arrayNew = this.newArray(arrayOld, available, "inverse");
                this.m_OutputToken = new Token(arrayNew);
                break;
            }
            case BOTH: {
                indices.sort();
                arrayNew = Array.newInstance(arrayOld.getClass(), 2);
                Array.set(arrayNew, 0, this.newArray(arrayOld, indices, "split"));
                Array.set(arrayNew, 1, this.newArray(arrayOld, available, "inverse"));
                this.m_OutputToken = new Token(arrayNew);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled split result: " + this.m_SplitResult);
            }
        }
        this.m_OutputToken = new Token(arrayNew);
        this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        return result;
    }
}

