/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.data.random.AbstractSeededRandomNumberGenerator;
import adams.data.random.Random;

public class Exponential
extends AbstractSeededRandomNumberGenerator<Double> {
    private static final long serialVersionUID = -8911652004331474297L;
    protected double m_Lambda;
    protected Random m_Random;

    public String globalInfo() {
        return "Generates random numbers from an Exponential random variable (Mean = 1/lambda, variance = 1/lambda^2).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lambda", "lambda", (Object)1.0);
    }

    public void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setLambda(double value) {
        if (value != 0.0) {
            this.m_Lambda = value;
            this.reset();
        } else {
            this.getLogger().severe("Lambda cannot be zero!");
        }
    }

    public double getLambda() {
        return this.m_Lambda;
    }

    public String lambdaTipText() {
        return "The lambda parameter for the exponential random variable.";
    }

    protected void check() {
        super.check();
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
    }

    protected Double doNext() {
        return this.m_Random.exponential(this.m_Lambda);
    }
}

