/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.data.random.AbstractSeededRandomNumberGenerator;
import adams.data.random.Random;
import adams.data.random.RandomIntegerRangeGenerator;

public class JMathArrayInt
extends AbstractSeededRandomNumberGenerator<Integer>
implements RandomIntegerRangeGenerator<Integer> {
    private static final long serialVersionUID = 8058404120296659028L;
    protected int m_MinValue;
    protected int m_MaxValue;
    protected Random m_Random;

    public String globalInfo() {
        return "Random generator that generates random integers using JMathArray's randInt method.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-value", "minValue", (Object)1);
        this.m_OptionManager.add("max-value", "maxValue", (Object)1000);
    }

    public void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setMinValue(int value) {
        this.m_MinValue = value;
        this.reset();
    }

    public int getMinValue() {
        return this.m_MinValue;
    }

    public String minValueTipText() {
        return "The smallest number that could be generated.";
    }

    public void setMaxValue(int value) {
        this.m_MaxValue = value;
        this.reset();
    }

    public int getMaxValue() {
        return this.m_MaxValue;
    }

    public String maxValueTipText() {
        return "The largest number that could be generated.";
    }

    protected void check() {
        super.check();
        if (this.getMinValue() >= this.getMaxValue()) {
            throw new IllegalStateException("MinValue must be smaller than MaxValue: MinValue=" + this.getMinValue() + ", MaxValue=" + this.getMaxValue());
        }
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
    }

    protected Integer doNext() {
        return this.m_Random.randInt(this.m_MinValue, this.m_MaxValue);
    }
}

