/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.SplitResultType;
import adams.data.random.JavaRandomInt;
import adams.data.random.RandomIntegerRangeGenerator;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;

public abstract class AbstractArraySplitter
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 8536100625511019961L;
    protected RandomIntegerRangeGenerator m_Generator;
    protected SplitResultType m_SplitResult;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new JavaRandomInt());
        this.m_OptionManager.add("split-result", "splitResult", (Object)SplitResultType.SPLIT);
    }

    public void setGenerator(RandomIntegerRangeGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public RandomIntegerRangeGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The random number generator to use for selecting the elements.";
    }

    public void setSplitResult(SplitResultType value) {
        this.m_SplitResult = value;
        this.reset();
    }

    public SplitResultType getSplitResult() {
        return this.m_SplitResult;
    }

    public String splitResultTipText() {
        return "The type of data to return: e.g., the sample, the inverse of the sample or both (split and inverse).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator, (String)"generator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"splitResult", (Object)this.m_SplitResult, (String)", result: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    public Class[] generates() {
        return new Class[]{Unknown[].class};
    }

    protected Object newArray(Object arrayOld, TIntArrayList indices, String log) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Indices (" + log + "): " + indices);
        }
        Object result = Array.newInstance(arrayOld.getClass().getComponentType(), indices.size());
        for (int i = 0; i < indices.size(); ++i) {
            Array.set(result, i, Utils.deepCopy((Object)Array.get(arrayOld, indices.get(i))));
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

