/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Randomizable;
import adams.data.conversion.AbstractConversion;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class RandomizeArray
extends AbstractConversion
implements Randomizable {
    private static final long serialVersionUID = -9193788162804738123L;
    protected long m_Seed;

    public String globalInfo() {
        return "Randomizes the order of the elements in the array.\nThe random number generator gets initialized every time with the given seed.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public Class accepts() {
        return Object[].class;
    }

    public Class generates() {
        return Object[].class;
    }

    protected Object doConvert() throws Exception {
        Object[] result = (Object[])((Object[])this.m_Input).clone();
        Collections.shuffle(Arrays.asList(result), new Random(this.m_Seed));
        return result;
    }
}

