/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.data.random.AbstractSeededRandomNumberGenerator;
import adams.data.random.CommonsRandomNumberGenerator;
import adams.data.random.RandomIntegerRangeGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class AbstractCommonsRandomNumberGenerator
extends AbstractSeededRandomNumberGenerator<Number>
implements CommonsRandomNumberGenerator<Number>,
RandomIntegerRangeGenerator<Number> {
    private static final long serialVersionUID = 5972847638157742849L;
    protected boolean m_GenerateDoubles;
    protected int m_MinValue;
    protected int m_MaxValue;
    protected RandomGenerator m_Generator;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generate-doubles", "generateDoubles", (Object)false);
        this.m_OptionManager.add("min-value", "minValue", (Object)1);
        this.m_OptionManager.add("max-value", "maxValue", (Object)1000);
    }

    public void reset() {
        super.reset();
        this.m_Generator = null;
    }

    @Override
    public void setGenerateDoubles(boolean value) {
        this.m_GenerateDoubles = value;
        this.reset();
    }

    @Override
    public boolean getGenerateDoubles() {
        return this.m_GenerateDoubles;
    }

    @Override
    public String generateDoublesTipText() {
        return "If enabled, doubles instead of integers are returned.";
    }

    @Override
    public void setMinValue(int value) {
        this.m_MinValue = value;
        this.reset();
    }

    @Override
    public int getMinValue() {
        return this.m_MinValue;
    }

    @Override
    public String minValueTipText() {
        return "The smallest integer that could be generated.";
    }

    @Override
    public void setMaxValue(int value) {
        this.m_MaxValue = value;
        this.reset();
    }

    @Override
    public int getMaxValue() {
        return this.m_MaxValue;
    }

    @Override
    public String maxValueTipText() {
        return "The largest integer that could be generated.";
    }

    @Override
    public abstract RandomGenerator getRandomGenerator();

    protected void check() {
        super.check();
        if (this.getMinValue() >= this.getMaxValue()) {
            throw new IllegalStateException("MinValue must be smaller than MaxValue: MinValue=" + this.getMinValue() + ", MaxValue=" + this.getMaxValue());
        }
        if (this.m_Generator == null) {
            this.m_Generator = this.getRandomGenerator();
        }
    }

    protected Number doNext() {
        if (this.m_GenerateDoubles) {
            return this.m_Generator.nextDouble();
        }
        return this.m_Generator.nextInt(this.m_MaxValue - this.m_MinValue + 1) + this.m_MinValue;
    }
}

