/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Randomizable;
import adams.data.conversion.AbstractConversion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

public class RandomizeCollection
extends AbstractConversion
implements Randomizable {
    private static final long serialVersionUID = -9193788162804738123L;
    protected long m_Seed;

    public String globalInfo() {
        return "Randomizes the order of the elements in the collection.\nThe random number generator gets initialized every time with the given seed.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public Class accepts() {
        return Collection.class;
    }

    public Class generates() {
        return Collection.class;
    }

    protected Object doConvert() throws Exception {
        Collection input = (Collection)this.m_Input;
        Object[] array = input.toArray();
        Collections.shuffle(Arrays.asList(array), new Random(this.m_Seed));
        Collection result = (Collection)input.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        result.addAll(Arrays.asList(array));
        return result;
    }
}

