/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.random.JavaRandomInt;
import adams.data.random.RandomNumberGenerator;
import adams.flow.condition.bool.AbstractExpression;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.parser.BooleanExpressionText;
import java.util.HashMap;

public class RandomNumberExpression
extends AbstractExpression {
    private static final long serialVersionUID = 5195367806715940844L;
    protected RandomNumberGenerator m_Generator;

    public String globalInfo() {
        return "Evaluates to 'true' if the expression evaluates to 'true'.\nThe 'X' in the expression is the number generated by the random number generator.\n\nThe following grammar is used for evaluating the boolean expressions:\n\n" + this.getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new JavaRandomInt());
    }

    public String getQuickInfo() {
        return super.getQuickInfo() + QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator, (String)", generator: ");
    }

    protected BooleanExpressionText getDefaultExpression() {
        return new BooleanExpressionText("X < 500");
    }

    public String expressionTipText() {
        return "The expression to evaluate using the current random number obtained from the generator; expressions that consists solely of a variable (eg '@{blah}') get automatically wrapped in parentheses, since the expression string gets interpreted as attached variable instead.";
    }

    public void setGenerator(RandomNumberGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public RandomNumberGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator that generates a new random number each time a token arrives.";
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        String exp = owner != null ? owner.getVariables().expand(this.getExpression().getValue()) : this.getExpression().getValue();
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("X", this.m_Generator.next().doubleValue());
        return this.doEvaluate(exp, symbols);
    }
}

