/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DeepCopyOperator;
import adams.core.QuickInfoHelper;
import adams.core.classmanager.ClassManager;
import adams.core.option.OptionHandler;
import adams.data.SplitResultType;
import adams.data.random.JavaRandomInt;
import adams.data.random.RandomIntegerRangeGenerator;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;

public abstract class AbstractArraySplitter
extends AbstractTransformer
implements DeepCopyOperator {
    private static final long serialVersionUID = 8536100625511019961L;
    protected RandomIntegerRangeGenerator m_Generator;
    protected SplitResultType m_SplitResult;
    protected boolean m_DeepCopy;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new JavaRandomInt());
        this.m_OptionManager.add("split-result", "splitResult", (Object)SplitResultType.SPLIT);
        this.m_OptionManager.add("deep-copy", "deepCopy", (Object)true);
    }

    public void setGenerator(RandomIntegerRangeGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public RandomIntegerRangeGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The random number generator to use for selecting the elements.";
    }

    public void setSplitResult(SplitResultType value) {
        this.m_SplitResult = value;
        this.reset();
    }

    public SplitResultType getSplitResult() {
        return this.m_SplitResult;
    }

    public String splitResultTipText() {
        return "The type of data to return: e.g., the sample, the inverse of the sample or both (split and inverse).";
    }

    public void setDeepCopy(boolean value) {
        this.m_DeepCopy = value;
        this.reset();
    }

    public boolean getDeepCopy() {
        return this.m_DeepCopy;
    }

    public String deepCopyTipText() {
        return "If enabled, a deep copy of each array element is performed before transferring it into the target array.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator, (String)"generator: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"splitResult", (Object)this.m_SplitResult, (String)", result: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"deepCopy", (boolean)this.m_DeepCopy, (String)"deep copy", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    public Class[] generates() {
        return new Class[]{Unknown[].class};
    }

    protected Object newArray(Object arrayOld, TIntArrayList indices, String log) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Indices (" + log + "): " + indices);
        }
        Object result = Array.newInstance(arrayOld.getClass().getComponentType(), indices.size());
        for (int i = 0; i < indices.size(); ++i) {
            if (this.m_DeepCopy) {
                Array.set(result, i, ClassManager.getSingleton().deepCopy(Array.get(arrayOld, indices.get(i))));
                continue;
            }
            Array.set(result, i, Array.get(arrayOld, indices.get(i)));
        }
        return result;
    }
}

