/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.Randomizable;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.util.Random;

public class ArrayRandomize
extends AbstractTransformer
implements Randomizable {
    private static final long serialVersionUID = 4439862057128462481L;
    protected long m_Seed;

    public String globalInfo() {
        return "Randomizes an array using a copy.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
    }

    public void setSeed(long value) {
        this.m_Seed = value;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the randomization.";
    }

    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    public Class[] generates() {
        return new Class[]{Unknown[].class};
    }

    protected String doExecute() {
        String result = null;
        Object array = this.m_InputToken.getPayload();
        Object copy = null;
        if (!array.getClass().isArray()) {
            result = "Input is not an array!";
        }
        if (result == null) {
            try {
                copy = ObjectCopyHelper.copyObject((Object)array);
            }
            catch (Exception e) {
                result = this.handleException("Failed to create copy of array!", e);
            }
        }
        if (result == null) {
            int i;
            int len = Array.getLength(array);
            TIntArrayList indices = new TIntArrayList(len);
            for (i = 0; i < len; ++i) {
                indices.add(i);
            }
            indices.shuffle(new Random(this.m_Seed));
            for (i = 0; i < len; ++i) {
                Array.set(copy, i, Array.get(array, indices.get(i)));
            }
            this.m_OutputToken = new Token(copy);
        }
        return result;
    }
}

