/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.net.PortManager;
import adams.core.option.OptionHandler;
import adams.flow.core.RunnableWithLogging;
import adams.flow.standalone.rats.input.AbstractBufferedRatInput;
import gnu.trove.list.array.TByteArrayList;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class Socket
extends AbstractBufferedRatInput {
    private static final long serialVersionUID = 3258626251085265978L;
    protected int m_Port;
    protected int m_Timeout;
    protected BaseCharset m_Encoding;
    protected boolean m_OutputString;
    protected transient ServerSocket m_Server;
    protected transient java.net.Socket m_Client;

    public String globalInfo() {
        return "Listens on the specified port for incoming data.\nCan either output raw byte arrays or strings (using the specified encoding).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("port", "port", (Object)8000, (Number)1, (Number)65535);
        this.m_OptionManager.add("timeout", "timeout", (Object)3000, (Number)100, null);
        this.m_OptionManager.add("output-string", "outputString", (Object)false);
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to listen on.";
    }

    public void setTimeout(int value) {
        if (this.getOptionManager().isValid("timeout", (Number)value)) {
            this.m_Timeout = value;
            this.reset();
        }
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public String timeoutTipText() {
        return "The timeout in milli-second for waiting on new client connections.";
    }

    public void setOutputString(boolean value) {
        this.m_OutputString = value;
        this.reset();
    }

    public boolean getOutputString() {
        return this.m_OutputString;
    }

    public String outputStringTipText() {
        return "If enabled, a string with the specified encoding is generated from the incoming byte array.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding for sending the data.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)"listening on ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputString", (Object)(this.m_OutputString ? "string" : "byte[]"), (String)", outputting: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding, (String)", encoding: ");
        return result;
    }

    public Class generates() {
        if (this.m_OutputString) {
            return String.class;
        }
        return byte[].class;
    }

    public String initReception() {
        String result = super.initReception();
        if (result == null && this.m_Server == null) {
            try {
                this.m_Server = new ServerSocket(this.m_Port);
                this.m_Server.setSoTimeout(this.m_Timeout);
                PortManager.getSingleton().bind((Object)this, this.m_Port);
            }
            catch (Exception e) {
                result = this.handleException("Failed to listen on port: " + this.m_Port, e);
                this.m_Server = null;
            }
        }
        return result;
    }

    protected String doReceive() {
        if (this.m_Server != null) {
            RunnableWithLogging run = new RunnableWithLogging(){

                protected void doRun() {
                    while (Socket.this.m_Server != null && !this.isStopped() && !Socket.this.m_Server.isClosed()) {
                        try {
                            int b;
                            Socket.this.m_Client = Socket.this.m_Server.accept();
                            InputStream in = Socket.this.m_Client.getInputStream();
                            TByteArrayList bytes = new TByteArrayList();
                            while (!this.isStopped() && (b = in.read()) != -1) {
                                bytes.add((byte)b);
                            }
                            if (Socket.this.m_Client != null) {
                                Socket.this.m_Client.close();
                            }
                            Socket.this.m_Client = null;
                            if (this.isStopped()) continue;
                            if (Socket.this.m_OutputString) {
                                Socket.this.bufferData(new String(bytes.toArray(), Socket.this.m_Encoding.charsetValue()));
                                continue;
                            }
                            Socket.this.bufferData(bytes.toArray());
                        }
                        catch (SocketTimeoutException in) {
                        }
                        catch (SocketException se) {
                            if (this.isStopped()) continue;
                            Socket.this.handleException("Failed to accept connection!", se);
                        }
                        catch (Exception e) {
                            Socket.this.handleException("Failed to accept connection!", e);
                        }
                    }
                }
            };
            new Thread((Runnable)run).start();
        }
        return null;
    }

    public void stopExecution() {
        super.stopExecution();
        if (this.m_Server != null) {
            try {
                this.m_Server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Server = null;
        }
        if (this.m_Client != null) {
            try {
                this.m_Client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Client = null;
        }
    }

    public void cleanUp() {
        if (this.m_Server != null) {
            try {
                if (!this.m_Server.isClosed()) {
                    this.m_Server.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Server = null;
        }
        super.cleanUp();
    }
}

