/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.net.AbstractSendEmail;
import adams.core.net.Email;
import adams.core.net.EmailHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.SMTPConnection;
import adams.flow.standalone.rats.output.AbstractRatOutput;

public class SendEmail
extends AbstractRatOutput {
    private static final long serialVersionUID = 8536200128302047375L;
    protected AbstractSendEmail m_SendEmail;

    public String globalInfo() {
        return "Transmitter for sending emails.\n" + (EmailHelper.isEnabled() ? "" : "Email support not enabled, check email setup!");
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("send-email", "sendEmail", (Object)EmailHelper.getDefaultSendEmail());
    }

    public String getQuickInfo() {
        if (!EmailHelper.isEnabled()) {
            return "No email support enabled, check email setup!";
        }
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"sendEmail", this.m_SendEmail.getClass(), (String)"send: ");
        return result;
    }

    public void setSendEmail(AbstractSendEmail value) {
        this.m_SendEmail = value;
        this.reset();
    }

    public AbstractSendEmail getSendEmail() {
        return this.m_SendEmail;
    }

    public String sendEmailTipText() {
        return "The engine for sending the emails.";
    }

    public Class[] accepts() {
        return new Class[]{Email.class};
    }

    protected String check() {
        String result = super.check();
        if (result == null && !EmailHelper.isEnabled()) {
            result = "No email support enabled, check email setup!";
        }
        return result;
    }

    protected void initSession() throws Exception {
        if (this.m_SendEmail.requiresSmtpSessionInitialization()) {
            SMTPConnection conn = (SMTPConnection)ActorUtils.findClosestType((Actor)this.getOwner(), SMTPConnection.class, (boolean)true);
            if (conn != null) {
                conn.initializeSmtpSession(this.m_SendEmail);
            } else {
                this.m_SendEmail.initializeSmtpSession(EmailHelper.getSmtpServer(), EmailHelper.getSmtpPort(), EmailHelper.getSmtpStartTLS(), EmailHelper.getSmtpUseSSL(), EmailHelper.getSmtpTimeout(), EmailHelper.getSmtpRequiresAuthentication(), EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword());
            }
        }
    }

    protected String doTransmit() {
        String result = null;
        Email email = (Email)this.m_Input;
        try {
            this.initSession();
            if (!this.m_SendEmail.sendMail(email)) {
                result = "Failed to send email, check console output!";
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to send email: ", e);
        }
        return result;
    }
}

