/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.FTPConnection;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FtpUpload
extends AbstractRatOutput {
    private static final long serialVersionUID = -641728833085302442L;
    protected String m_RemoteDir;
    protected int m_WaitFTP;
    protected FTPConnection m_Connection;

    public String globalInfo() {
        return "Sends the incoming files to a FTP server.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("wait-ftp", "waitFTP", (Object)0, (Number)0, null);
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
    }

    public void setWaitFTP(int value) {
        if (value >= 0) {
            this.m_WaitFTP = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of milli-seconds to wait must be >=0, provided: " + value);
        }
    }

    public int getWaitFTP() {
        return this.m_WaitFTP;
    }

    public String waitFTPTipText() {
        return "The number of milli-seconds to wait before FTP-ing the files.";
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The FTP directory to upload the file(s) to.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"waitFTP", (Object)this.getWaitFTP(), (String)"wait-ftp: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"removeDir", (Object)this.getRemoteDir(), (String)", remote dir: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    public String check() {
        Object result = super.check();
        if (result == null) {
            this.m_Connection = (FTPConnection)ActorUtils.findClosestType((Actor)this.m_Owner, FTPConnection.class);
            if (this.m_Connection == null) {
                result = "No " + FTPConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String ftp(String filename) {
        String result = null;
        PlaceholderFile file = new PlaceholderFile(filename);
        String remotefile = this.m_RemoteDir + "/" + file.getName();
        FTPClient client = this.m_Connection.getFTPClient();
        BufferedInputStream stream = null;
        FileInputStream fis = null;
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Uploading " + (File)file + " to " + remotefile);
            }
            fis = new FileInputStream(file.getAbsoluteFile());
            stream = new BufferedInputStream(fis);
            client.storeFile(remotefile, (InputStream)stream);
            stream.close();
        }
        catch (Exception e) {
            try {
                result = this.handleException("Failed to ftp '" + (File)file + "' to '" + remotefile + "'!", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(stream);
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly(stream);
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((InputStream)stream);
        FileUtils.closeQuietly((InputStream)fis);
        return result;
    }

    protected String doTransmit() {
        String file;
        String result = null;
        String[] files = FileUtils.toStringArray((Object)this.m_Input);
        this.doWait(this.m_WaitFTP);
        String[] stringArray = files;
        int n = stringArray.length;
        for (int i = 0; i < n && (result = this.ftp(file = stringArray[i])) == null; ++i) {
        }
        return result;
    }
}

