/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.redisaction.AbstractRedisAction;
import adams.flow.sink.redisaction.Null;
import adams.flow.standalone.RedisConnection;
import adams.flow.standalone.rats.output.AbstractRatOutput;

public class RedisAction
extends AbstractRatOutput {
    private static final long serialVersionUID = 2632516604969652894L;
    protected AbstractRedisAction m_Action;
    protected transient RedisConnection m_Connection;

    public String globalInfo() {
        return "Executes the specified Redis action.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "action", (Object)new Null());
    }

    public void setAction(AbstractRedisAction value) {
        this.m_Action = value;
        this.reset();
    }

    public AbstractRedisAction getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The action to execute.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"action", (Object)this.m_Action, (String)"action: ");
    }

    public Class[] accepts() {
        return this.m_Action.accepts();
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (RedisConnection)ActorUtils.findClosestType((Actor)this.m_Owner, RedisConnection.class, (boolean)true);
            if (this.m_Connection == null) {
                result = "Failed to locate a " + Utils.classToString(RedisConnection.class) + "!";
            }
        }
        return result;
    }

    protected String doTransmit() {
        String result;
        try {
            result = this.m_Action.execute(this.m_Connection, this.m_Input);
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute action '" + this.m_Action + "' using: " + this.m_Input, e);
        }
        return result;
    }
}

