/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.redis.RedisDataType;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.RedisConnection;
import adams.flow.standalone.rats.output.AbstractRatOutput;

public class RedisPublish
extends AbstractRatOutput {
    private static final long serialVersionUID = 2421975872152713034L;
    protected String m_Channel;
    protected RedisDataType m_Type;
    protected transient RedisConnection m_Connection;

    public String globalInfo() {
        return "Publishes the incoming message to the specified channel.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("channel", "channel", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)RedisDataType.STRING);
    }

    public void setChannel(String value) {
        this.m_Channel = value;
        this.reset();
    }

    public String getChannel() {
        return this.m_Channel;
    }

    public String channelTipText() {
        return "The name of the channel to publish on.";
    }

    public void setType(RedisDataType value) {
        this.m_Type = value;
        this.reset();
    }

    public RedisDataType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the data.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"channel", (Object)(this.m_Channel.isEmpty() ? "-empty-" : this.m_Channel), (String)"channel: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)this.m_Type, (String)", type: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{this.m_Type.getDataClass()};
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (RedisConnection)ActorUtils.findClosestType((Actor)this.m_Owner, RedisConnection.class, (boolean)true);
            if (this.m_Connection == null) {
                result = "Failed to locate a " + Utils.classToString(RedisConnection.class) + "!";
            }
        }
        return result;
    }

    protected String doTransmit() {
        try {
            switch (this.m_Type) {
                case STRING: {
                    this.m_Connection.getConnection(this.m_Type.getCodecClass()).sync().publish((Object)this.m_Channel, (Object)("" + this.m_Input));
                    return null;
                }
                case BYTE_ARRAY: {
                    this.m_Connection.getConnection(this.m_Type.getCodecClass()).sync().publish((Object)this.m_Channel.getBytes(), (Object)("" + this.m_Input).getBytes());
                    return null;
                }
            }
            return "Unhandled redis data type: " + this.m_Type;
        }
        catch (Exception e) {
            String result = this.handleException("Failed to publish on channel '" + this.m_Channel + "': " + this.m_Input, e);
            return result;
        }
    }
}

