/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.control;

import adams.core.MessageCollection;
import adams.core.Pausable;
import adams.core.Utils;
import adams.flow.control.Flow;
import adams.flow.control.RunningFlowsRegistry;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.rest.AbstractRESTPluginWithFlowContext;
import adams.flow.standalone.Rat;
import adams.flow.standalone.Rats;
import adams.flow.standalone.ratcontrol.AbstractControlPanel;
import adams.flow.standalone.ratcontrol.AbstractControlState;
import adams.flow.standalone.ratcontrol.RatControlPanel;
import adams.flow.standalone.ratcontrol.RatControlState;
import adams.scripting.command.flow.SendRatControlCommand;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

public class RatControl
extends AbstractRESTPluginWithFlowContext {
    private static final long serialVersionUID = -3247606641885793684L;

    public String globalInfo() {
        return "Allows control of Rat actors in running flows with active " + Utils.classToString(RatControl.class) + " actors.";
    }

    protected Actor getFlow(int id, MessageCollection errors) {
        Flow result = null;
        if (id == -1) {
            if (RunningFlowsRegistry.getSingleton().size() == 1) {
                result = RunningFlowsRegistry.getSingleton().flows()[0];
            } else {
                errors.add("Using ID '-1' is only allowed if there is just a single flow registered (registered: " + RunningFlowsRegistry.getSingleton().size() + ")");
            }
        } else {
            result = RunningFlowsRegistry.getSingleton().getFlow(id);
            if (result == null) {
                errors.add("Failed to retrieve flow for ID " + id + "!");
            }
        }
        if (errors.isEmpty()) {
            return result;
        }
        return null;
    }

    @GET
    @Path(value="/rats/control/flows")
    public String flows() {
        JsonArray jflows = new JsonArray();
        JsonObject result = new JsonObject();
        result.add("flows", (JsonElement)jflows);
        for (Integer id : RunningFlowsRegistry.getSingleton().ids()) {
            Flow flow = RunningFlowsRegistry.getSingleton().getFlow(id.intValue());
            if (flow == null) continue;
            JsonObject jflow = new JsonObject();
            jflow.addProperty("id", (Number)id);
            jflow.addProperty("paused", Boolean.valueOf(flow.isPaused()));
            jflow.addProperty("stopped", Boolean.valueOf(flow.isStopped()));
            jflow.addProperty("root", flow.getRoot().getName());
            jflow.addProperty("annotation", flow.getRoot().getAnnotations().getValue());
            jflow.addProperty("path", flow.getVariables().get("flow_filename_long"));
            jflows.add((JsonElement)jflow);
        }
        return result.toString();
    }

    @GET
    @Path(value="/rats/control/status/{id}")
    public String status(@PathParam(value="id") int id) {
        MessageCollection errors = new MessageCollection();
        Actor flow = this.getFlow(id, errors);
        if (!errors.isEmpty()) {
            return errors.toString();
        }
        JsonObject result = new JsonObject();
        JsonArray groups = new JsonArray();
        result.add("groups", (JsonElement)groups);
        result.addProperty("id", (Number)id);
        String ratspath = "";
        JsonObject group = new JsonObject();
        JsonArray rats = new JsonArray();
        for (Actor a : ActorUtils.enumerate((Actor)flow, (Class[])new Class[]{adams.flow.standalone.RatControl.class})) {
            adams.flow.standalone.RatControl rc = (adams.flow.standalone.RatControl)a;
            for (AbstractControlState state : rc.getControlStates()) {
                Actor actor = state.getActor();
                if (actor instanceof Rats) {
                    ratspath = actor.getFullName();
                    group = new JsonObject();
                    group.addProperty("name", actor.getName());
                    rats = new JsonArray();
                    group.add("rats", (JsonElement)rats);
                    groups.add((JsonElement)group);
                    continue;
                }
                JsonObject rat = new JsonObject();
                rat.addProperty("name", state.getActor().getFullName().substring(ratspath.length() + 1));
                rat.addProperty("full", state.getActor().getFullName());
                rat.addProperty("pausable", Boolean.valueOf(state.isPausable()));
                rat.addProperty("paused", Boolean.valueOf(((Pausable)actor).isPaused()));
                if (state instanceof RatControlState) {
                    rat.addProperty("stoppable", Boolean.valueOf(((RatControlState)state).isStoppable()));
                    rat.addProperty("stopped", Boolean.valueOf(!((Rat)actor).isRunnableActive()));
                } else {
                    rat.addProperty("stoppable", Boolean.valueOf(false));
                    rat.addProperty("stopped", Boolean.valueOf(false));
                }
                rat.addProperty("interactive", Boolean.valueOf(ActorUtils.isInteractive((Actor)actor)));
                rats.add((JsonElement)rat);
            }
        }
        return result.toString();
    }

    @GET
    @Path(value="/rats/control/command/{id}/{cmd}")
    public String command(@PathParam(value="id") int id, @PathParam(value="cmd") String cmd, @FormParam(value="rat") String ratpath) {
        cmd = cmd.toUpperCase();
        SendRatControlCommand.Command command = SendRatControlCommand.Command.valueOf((String)cmd);
        MessageCollection errors = new MessageCollection();
        Actor flow = this.getFlow(id, errors);
        if (!errors.isEmpty()) {
            return errors.toString();
        }
        for (Actor a : ActorUtils.enumerate((Actor)flow, (Class[])new Class[]{adams.flow.standalone.RatControl.class})) {
            adams.flow.standalone.RatControl rc = (adams.flow.standalone.RatControl)a;
            for (AbstractControlPanel panel : rc.getControlPanels()) {
                Actor actor = panel.getActor();
                if (!actor.getFullName().equals(ratpath)) continue;
                switch (command) {
                    case PAUSE: {
                        if (((Pausable)actor).isPaused()) {
                            return "Already paused";
                        }
                        panel.pauseOrResume();
                        return "Success";
                    }
                    case RESUME: {
                        if (!((Pausable)actor).isPaused()) {
                            return "Already running";
                        }
                        panel.pauseOrResume();
                        return "Success";
                    }
                    case STOP: {
                        if (panel instanceof RatControlPanel) {
                            Rat rat = (Rat)actor;
                            if (!rat.isRunnableActive()) {
                                return "Already stopped";
                            }
                            rat.stopRunnable();
                            return "Success";
                        }
                        return "Command not supported";
                    }
                    case START: {
                        if (panel instanceof RatControlPanel) {
                            Rat rat = (Rat)actor;
                            if (rat.isRunnableActive()) {
                                return "Already running";
                            }
                            rat.startRunnable();
                            return "Success";
                        }
                        return "Command not supported";
                    }
                }
                return "Command not supported";
            }
        }
        return "Failed to locate actor ('" + ratpath + "')? ";
    }
}

